/*
 * Decompiled with CFR 0.152.
 */
package com.oldschooljail.model;

import java.util.UUID;

public class JailedPlayer {
    private final UUID playerUuid;
    private final String jailName;
    private final long releaseTime;
    private final String reason;
    private final String jailedBy;
    private final double originalX;
    private final double originalY;
    private final double originalZ;
    private final float originalYaw;
    private final float originalPitch;
    private final String originalWorld;

    public JailedPlayer(UUID playerUuid, String jailName, long releaseTime, String reason, String jailedBy, double originalX, double originalY, double originalZ, float originalYaw, float originalPitch, String originalWorld) {
        this.playerUuid = playerUuid;
        this.jailName = jailName;
        this.releaseTime = releaseTime;
        this.reason = reason;
        this.jailedBy = jailedBy;
        this.originalX = originalX;
        this.originalY = originalY;
        this.originalZ = originalZ;
        this.originalYaw = originalYaw;
        this.originalPitch = originalPitch;
        this.originalWorld = originalWorld;
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public String getJailName() {
        return this.jailName;
    }

    public long getReleaseTime() {
        return this.releaseTime;
    }

    public String getReason() {
        return this.reason;
    }

    public String getJailedBy() {
        return this.jailedBy;
    }

    public double getOriginalX() {
        return this.originalX;
    }

    public double getOriginalY() {
        return this.originalY;
    }

    public double getOriginalZ() {
        return this.originalZ;
    }

    public float getOriginalYaw() {
        return this.originalYaw;
    }

    public float getOriginalPitch() {
        return this.originalPitch;
    }

    public String getOriginalWorld() {
        return this.originalWorld;
    }

    public long getRemainingTimeSeconds() {
        return Math.max(0L, (this.releaseTime - System.currentTimeMillis()) / 1000L);
    }

    public boolean shouldBeReleased() {
        return System.currentTimeMillis() >= this.releaseTime;
    }
}

