/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.event.RegisterNamedRenderTypesEvent;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.ApiStatus;

public final class NamedRenderTypeManager {
    private static ImmutableMap<class_2960, RenderTypeGroup> RENDER_TYPES;

    public static RenderTypeGroup get(class_2960 name) {
        return (RenderTypeGroup)RENDER_TYPES.getOrDefault((Object)name, (Object)RenderTypeGroup.EMPTY);
    }

    @ApiStatus.Internal
    public static void init() {
        HashMap<class_2960, RenderTypeGroup> renderTypes = new HashMap<class_2960, RenderTypeGroup>();
        NamedRenderTypeManager.preRegisterVanillaRenderTypes(renderTypes);
        RegisterNamedRenderTypesEvent event = new RegisterNamedRenderTypesEvent(renderTypes);
        ModLoader.get().postEventWrapContainerInModOrder(event);
        RENDER_TYPES = ImmutableMap.copyOf(renderTypes);
    }

    private static void preRegisterVanillaRenderTypes(Map<class_2960, RenderTypeGroup> blockRenderTypes) {
        blockRenderTypes.put(new class_2960("solid"), new RenderTypeGroup(class_1921.method_23577(), ForgeRenderTypes.ITEM_LAYERED_SOLID.get()));
        blockRenderTypes.put(new class_2960("cutout"), new RenderTypeGroup(class_1921.method_23581(), ForgeRenderTypes.ITEM_LAYERED_CUTOUT.get()));
        blockRenderTypes.put(new class_2960("cutout_mipped"), new RenderTypeGroup(class_1921.method_23579(), ForgeRenderTypes.ITEM_LAYERED_CUTOUT.get()));
        blockRenderTypes.put(new class_2960("cutout_mipped_all"), new RenderTypeGroup(class_1921.method_23579(), ForgeRenderTypes.ITEM_LAYERED_CUTOUT_MIPPED.get()));
        blockRenderTypes.put(new class_2960("translucent"), new RenderTypeGroup(class_1921.method_23583(), ForgeRenderTypes.ITEM_LAYERED_TRANSLUCENT.get()));
        blockRenderTypes.put(new class_2960("tripwire"), new RenderTypeGroup(class_1921.method_29997(), ForgeRenderTypes.ITEM_LAYERED_TRANSLUCENT.get()));
    }

    private NamedRenderTypeManager() {
    }
}

