/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2484;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5614;
import net.minecraft.class_5616;
import net.minecraft.class_5617;
import net.minecraft.class_5619;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_922;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class EntityRenderersEvent
extends Event
implements IModBusEvent {
    @ApiStatus.Internal
    protected EntityRenderersEvent() {
    }

    public static class CreateSkullModels
    extends EntityRenderersEvent {
        private final ImmutableMap.Builder<class_2484.class_2485, class_5598> builder;
        private final class_5599 entityModelSet;

        @ApiStatus.Internal
        public CreateSkullModels(ImmutableMap.Builder<class_2484.class_2485, class_5598> builder, class_5599 entityModelSet) {
            this.builder = builder;
            this.entityModelSet = entityModelSet;
        }

        public class_5599 getEntityModelSet() {
            return this.entityModelSet;
        }

        public void registerSkullModel(class_2484.class_2485 type, class_5598 model) {
            this.builder.put((Object)type, (Object)model);
        }
    }

    public static class AddLayers
    extends EntityRenderersEvent {
        private final Map<class_1299<?>, class_897<?>> renderers;
        private final Map<String, class_897<? extends class_1657>> skinMap;
        private final class_5617.class_5618 context;

        @ApiStatus.Internal
        public AddLayers(Map<class_1299<?>, class_897<?>> renderers, Map<String, class_897<? extends class_1657>> playerRenderers, class_5617.class_5618 context) {
            this.renderers = renderers;
            this.skinMap = playerRenderers;
            this.context = context;
        }

        public Set<String> getSkins() {
            return this.skinMap.keySet();
        }

        @Nullable
        public <R extends class_897<? extends class_1657>> R getPlayerSkin(String skinName) {
            return (R)this.skinMap.get(skinName);
        }

        @Nullable
        public <R extends class_922<? extends class_1657, ? extends class_583<? extends class_1657>>> R getSkin(String skinName) {
            class_922 renderer;
            class_897<? extends class_1657> class_8972 = this.skinMap.get(skinName);
            return (R)(class_8972 instanceof class_922 ? (renderer = (class_922)class_8972) : null);
        }

        @Nullable
        public <T extends class_1297, R extends class_897<T>> R getEntityRenderer(class_1299<? extends T> entityType) {
            return (R)this.renderers.get(entityType);
        }

        @Nullable
        public <T extends class_1309, R extends class_922<T, ? extends class_583<T>>> R getRenderer(class_1299<? extends T> entityType) {
            class_922 renderer;
            class_897<?> class_8972 = this.renderers.get(entityType);
            return (R)(class_8972 instanceof class_922 ? (renderer = (class_922)class_8972) : null);
        }

        public class_5599 getEntityModels() {
            return this.context.method_32170();
        }

        public class_5617.class_5618 getContext() {
            return this.context;
        }
    }

    public static class RegisterRenderers
    extends EntityRenderersEvent {
        @ApiStatus.Internal
        public RegisterRenderers() {
        }

        public <T extends class_1297> void registerEntityRenderer(class_1299<? extends T> entityType, class_5617<T> entityRendererProvider) {
            class_5619.method_32173(entityType, entityRendererProvider);
        }

        public <T extends class_2586> void registerBlockEntityRenderer(class_2591<? extends T> blockEntityType, class_5614<T> blockEntityRendererProvider) {
            class_5616.method_32144(blockEntityType, blockEntityRendererProvider);
        }
    }

    public static class RegisterLayerDefinitions
    extends EntityRenderersEvent {
        @ApiStatus.Internal
        public RegisterLayerDefinitions() {
        }

        public void registerLayerDefinition(class_5601 layerLocation, Supplier<class_5607> supplier) {
            ForgeHooksClient.registerLayerDefinition(layerLocation, supplier);
        }
    }
}

