/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_2960;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;

public abstract class ModelEvent
extends Event {
    @ApiStatus.Internal
    protected ModelEvent() {
    }

    public static class RegisterGeometryLoaders
    extends ModelEvent
    implements IModBusEvent {
        private final Map<class_2960, io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader<?>> loaders;

        @ApiStatus.Internal
        public RegisterGeometryLoaders(Map<class_2960, io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader<?>> loaders) {
            this.loaders = loaders;
        }

        public void register(String name, IGeometryLoader<?> loader) {
            class_2960 key = new class_2960(ModLoadingContext.get().getActiveNamespace(), name);
            Preconditions.checkArgument((!this.loaders.containsKey(key) ? 1 : 0) != 0, (Object)("Geometry loader already registered: " + String.valueOf(key)));
            this.loaders.put(key, loader);
        }
    }

    public static class RegisterAdditional
    extends ModelEvent
    implements IModBusEvent {
        private final Set<class_2960> models;

        @ApiStatus.Internal
        public RegisterAdditional(Set<class_2960> models) {
            this.models = models;
        }

        public void register(class_2960 model) {
            this.models.add(model);
        }
    }

    public static class BakingCompleted
    extends ModelEvent
    implements IModBusEvent {
        private final class_1092 modelManager;
        private final Map<class_2960, class_1087> models;
        private final class_1088 modelBakery;

        @ApiStatus.Internal
        public BakingCompleted(class_1092 modelManager, Map<class_2960, class_1087> models, class_1088 modelBakery) {
            this.modelManager = modelManager;
            this.models = models;
            this.modelBakery = modelBakery;
        }

        public class_1092 getModelManager() {
            return this.modelManager;
        }

        public Map<class_2960, class_1087> getModels() {
            return this.models;
        }

        public class_1088 getModelBakery() {
            return this.modelBakery;
        }
    }

    public static class ModifyBakingResult
    extends ModelEvent
    implements IModBusEvent {
        private final Map<class_2960, class_1087> models;
        private final class_1088 modelBakery;

        @ApiStatus.Internal
        public ModifyBakingResult(Map<class_2960, class_1087> models, class_1088 modelBakery) {
            this.models = models;
            this.modelBakery = modelBakery;
        }

        public Map<class_2960, class_1087> getModels() {
            return this.models;
        }

        public class_1088 getModelBakery() {
            return this.modelBakery;
        }
    }
}

