/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_761;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;
import org.joml.Matrix4f;

public class RenderLevelStageEvent
extends Event {
    private final Stage stage;
    private final class_761 levelRenderer;
    private final class_4587 poseStack;
    private final Matrix4f projectionMatrix;
    private final int renderTick;
    private final float partialTick;
    private final class_4184 camera;
    private final class_4604 frustum;

    public RenderLevelStageEvent(Stage stage, class_761 levelRenderer, class_4587 poseStack, Matrix4f projectionMatrix, int renderTick, float partialTick, class_4184 camera, class_4604 frustum) {
        this.stage = stage;
        this.levelRenderer = levelRenderer;
        this.poseStack = poseStack;
        this.projectionMatrix = projectionMatrix;
        this.renderTick = renderTick;
        this.partialTick = partialTick;
        this.camera = camera;
        this.frustum = frustum;
    }

    public Stage getStage() {
        return this.stage;
    }

    public class_761 getLevelRenderer() {
        return this.levelRenderer;
    }

    public class_4587 getPoseStack() {
        return this.poseStack;
    }

    public Matrix4f getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public int getRenderTick() {
        return this.renderTick;
    }

    public float getPartialTick() {
        return this.partialTick;
    }

    public class_4184 getCamera() {
        return this.camera;
    }

    public class_4604 getFrustum() {
        return this.frustum;
    }

    public static class Stage {
        private static final Map<class_1921, Stage> RENDER_TYPE_STAGES = new HashMap<class_1921, Stage>();
        public static final Stage AFTER_SKY = Stage.register("after_sky", null);
        public static final Stage AFTER_SOLID_BLOCKS = Stage.register("after_solid_blocks", class_1921.method_23577());
        public static final Stage AFTER_CUTOUT_MIPPED_BLOCKS_BLOCKS = Stage.register("after_cutout_mipped_blocks", class_1921.method_23579());
        public static final Stage AFTER_CUTOUT_BLOCKS = Stage.register("after_cutout_blocks", class_1921.method_23581());
        public static final Stage AFTER_ENTITIES = Stage.register("after_entities", null);
        public static final Stage AFTER_BLOCK_ENTITIES = Stage.register("after_block_entities", null);
        public static final Stage AFTER_TRANSLUCENT_BLOCKS = Stage.register("after_translucent_blocks", class_1921.method_23583());
        public static final Stage AFTER_TRIPWIRE_BLOCKS = Stage.register("after_tripwire_blocks", class_1921.method_29997());
        public static final Stage AFTER_PARTICLES = Stage.register("after_particles", null);
        public static final Stage AFTER_WEATHER = Stage.register("after_weather", null);
        public static final Stage AFTER_LEVEL = Stage.register("after_level", null);
        private final String name;

        private Stage(String name) {
            this.name = name;
        }

        private static Stage register(class_2960 name, @Nullable class_1921 renderType) throws IllegalArgumentException {
            Stage stage = new Stage(name.toString());
            if (renderType != null && RENDER_TYPE_STAGES.putIfAbsent(renderType, stage) != null) {
                throw new IllegalArgumentException("Attempted to replace an existing RenderLevelStageEvent.Stage for a RenderType: Stage = " + String.valueOf(stage) + ", RenderType = " + String.valueOf(renderType));
            }
            return stage;
        }

        private static Stage register(String name, @Nullable class_1921 renderType) throws IllegalArgumentException {
            return Stage.register(new class_2960(name), renderType);
        }

        public String toString() {
            return this.name;
        }

        @Nullable
        public static Stage fromRenderType(class_1921 renderType) {
            return RENDER_TYPE_STAGES.get(renderType);
        }
    }

    public static class RegisterStageEvent
    extends Event
    implements IModBusEvent {
        public Stage register(class_2960 name, @Nullable class_1921 renderType) throws IllegalArgumentException {
            return Stage.register(name, renderType);
        }
    }
}

