/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1761;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.common.util.ConcatenatedListView;

public final class CreativeTabsScreenPage {
    private final List<class_1761> tabs;
    private final List<class_1761> topTabs;
    private final List<class_1761> bottomTabs;
    private final List<class_1761> visibleTabs;

    public CreativeTabsScreenPage(List<class_1761> tabs) {
        this.tabs = tabs;
        this.topTabs = new ArrayList<class_1761>();
        this.bottomTabs = new ArrayList<class_1761>();
        this.visibleTabs = ConcatenatedListView.of(tabs, CreativeModeTabRegistry.getDefaultTabs());
        int maxLength = 10;
        int topLength = maxLength / 2;
        int length = tabs.size();
        for (int i = 0; i < length; ++i) {
            class_1761 tab = tabs.get(i);
            (i < topLength ? this.topTabs : this.bottomTabs).add(tab);
        }
    }

    public List<class_1761> getVisibleTabs() {
        return this.visibleTabs.stream().filter(class_1761::method_47311).toList();
    }

    public boolean isTop(class_1761 tab) {
        if (!this.tabs.contains(tab)) {
            return CreativeModeTabRegistry.getDefaultTabs().indexOf(tab) < CreativeModeTabRegistry.getDefaultTabs().size() / 2;
        }
        return this.topTabs.contains(tab);
    }

    public int getColumn(class_1761 tab) {
        if (!this.tabs.contains(tab)) {
            return CreativeModeTabRegistry.getDefaultTabs().indexOf(tab) % (CreativeModeTabRegistry.getDefaultTabs().size() / 2) + 5;
        }
        return this.topTabs.contains(tab) ? this.topTabs.indexOf(tab) : this.bottomTabs.indexOf(tab);
    }

    public class_1761 getDefaultTab() {
        return this.tabs.get(0);
    }
}

