/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_421;
import net.minecraft.class_4280;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.bluspring.kilt.injections.client.gui.GuiGraphicsInjection;

public class LoadingErrorScreen
extends class_421 {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path modsDir;
    private final Path logFile;
    private final List<ModLoadingException> modLoadErrors;
    private final List<ModLoadingWarning> modLoadWarnings;
    private final Path dumpedLocation;
    private LoadingEntryList entryList;
    private class_2561 errorHeader;
    private class_2561 warningHeader;

    public LoadingErrorScreen(LoadingFailedException loadingException, List<ModLoadingWarning> warnings, File dumpedLocation) {
        super((class_2561)class_2561.method_43470((String)"Loading Error"), null);
        this.modLoadWarnings = warnings;
        this.modLoadErrors = loadingException == null ? Collections.emptyList() : loadingException.getErrors();
        this.modsDir = FMLPaths.MODSDIR.get();
        this.logFile = FMLPaths.GAMEDIR.get().resolve(Paths.get("logs", "latest.log"));
        this.dumpedLocation = dumpedLocation != null ? dumpedLocation.toPath() : null;
    }

    public void method_25426() {
        super.method_25426();
        this.method_37067();
        this.errorHeader = class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + ForgeI18n.parseMessage("fml.loadingerrorscreen.errorheader", this.modLoadErrors.size()) + String.valueOf(class_124.field_1070)));
        this.warningHeader = class_2561.method_43470((String)(String.valueOf(class_124.field_1054) + ForgeI18n.parseMessage("fml.loadingerrorscreen.warningheader", this.modLoadErrors.size()) + String.valueOf(class_124.field_1070)));
        int yOffset = 46;
        this.method_37063((class_364)new ExtendedButton(50, this.field_22790 - yOffset, this.field_22789 / 2 - 55, 20, (class_2561)class_2561.method_43470((String)ForgeI18n.parseMessage("fml.button.open.mods.folder", new Object[0])), b -> class_156.method_668().method_672(this.modsDir.toFile())));
        this.method_37063((class_364)new ExtendedButton(this.field_22789 / 2 + 5, this.field_22790 - yOffset, this.field_22789 / 2 - 55, 20, (class_2561)class_2561.method_43470((String)ForgeI18n.parseMessage("fml.button.open.file", this.logFile.getFileName())), b -> class_156.method_668().method_672(this.logFile.toFile())));
        if (this.modLoadErrors.isEmpty()) {
            this.method_37063((class_364)new ExtendedButton(this.field_22789 / 4, this.field_22790 - 24, this.field_22789 / 2, 20, (class_2561)class_2561.method_43470((String)ForgeI18n.parseMessage("fml.button.continue.launch", new Object[0])), b -> this.field_22787.method_1507(null)));
        } else {
            this.method_37063((class_364)new ExtendedButton(this.field_22789 / 4, this.field_22790 - 24, this.field_22789 / 2, 20, (class_2561)class_2561.method_43470((String)ForgeI18n.parseMessage("fml.button.open.file", this.dumpedLocation.getFileName())), b -> class_156.method_668().method_672(this.dumpedLocation.toFile())));
        }
        this.entryList = new LoadingEntryList(this, this.modLoadErrors, this.modLoadWarnings);
        this.method_25429((class_364)this.entryList);
        this.method_25395((class_364)this.entryList);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        this.entryList.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.drawMultiLineCenteredString(guiGraphics, this.field_22793, this.modLoadErrors.isEmpty() ? this.warningHeader : this.errorHeader, this.field_22789 / 2, 10);
        this.field_33816.forEach(button -> button.method_25394(guiGraphics, mouseX, mouseY, partialTick));
    }

    private void drawMultiLineCenteredString(class_332 guiGraphics, class_327 fr, class_2561 str, int x, int y) {
        for (class_5481 s : fr.method_1728((class_5348)str, this.field_22789)) {
            ((GuiGraphicsInjection)guiGraphics).drawString(fr, s, (float)((double)x - (double)fr.method_30880(s) / 2.0), (float)y, 0xFFFFFF, true);
            Objects.requireNonNull(fr);
            y += 9;
        }
    }

    public static class LoadingEntryList
    extends class_4280<LoadingMessageEntry> {
        LoadingEntryList(LoadingErrorScreen parent, List<ModLoadingException> errors, List<ModLoadingWarning> warnings) {
            boolean both;
            int n = parent.field_22789;
            int n2 = parent.field_22790;
            int n3 = parent.field_22790 - 50;
            int n4 = Math.max(errors.stream().mapToInt(error -> parent.field_22793.method_1728((class_5348)class_2561.method_43470((String)(error.getMessage() != null ? error.getMessage() : "")), parent.field_22789 - 20).size()).max().orElse(0), warnings.stream().mapToInt(warning -> parent.field_22793.method_1728((class_5348)class_2561.method_43470((String)(warning.formatToString() != null ? warning.formatToString() : "")), parent.field_22789 - 20).size()).max().orElse(0));
            Objects.requireNonNull(((LoadingErrorScreen)parent).field_22787.field_1772);
            super(Objects.requireNonNull(parent.field_22787), n, n2, 35, n3, n4 * 9 + 8);
            boolean bl = both = !errors.isEmpty() && !warnings.isEmpty();
            if (both) {
                this.method_25321((class_350.class_351)new LoadingMessageEntry(parent.errorHeader, true));
            }
            errors.forEach(e -> this.method_25321((class_350.class_351)new LoadingMessageEntry((class_2561)class_2561.method_43470((String)e.formatToString()))));
            if (both) {
                int maxChars = (this.field_22742 - 10) / ((LoadingErrorScreen)parent).field_22787.field_1772.method_1727("-");
                this.method_25321((class_350.class_351)new LoadingMessageEntry((class_2561)class_2561.method_43470((String)("\n" + Strings.repeat((String)"-", (int)maxChars) + "\n"))));
                this.method_25321((class_350.class_351)new LoadingMessageEntry(parent.warningHeader, true));
            }
            warnings.forEach(w -> this.method_25321((class_350.class_351)new LoadingMessageEntry((class_2561)class_2561.method_43470((String)w.formatToString()))));
        }

        protected int method_25329() {
            return this.getRight() - 6;
        }

        public int method_25322() {
            return this.field_22742;
        }

        public class LoadingMessageEntry
        extends class_4280.class_4281<LoadingMessageEntry> {
            private final class_2561 message;
            private final boolean center;

            LoadingMessageEntry(class_2561 message2) {
                this(message2, false);
            }

            LoadingMessageEntry(class_2561 message2, boolean center) {
                this.message = Objects.requireNonNull(message2);
                this.center = center;
            }

            public class_2561 method_37006() {
                return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.message});
            }

            public void method_25343(class_332 guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTick) {
                class_327 font = class_310.method_1551().field_1772;
                List strings = font.method_1728((class_5348)this.message, LoadingEntryList.this.field_22742 - 20);
                int y = top + 2;
                for (class_5481 string : strings) {
                    if (this.center) {
                        ((GuiGraphicsInjection)guiGraphics).drawString(font, string, (float)(left + LoadingEntryList.this.field_22742) - (float)font.method_30880(string) / 2.0f, (float)y, 0xFFFFFF, false);
                    } else {
                        guiGraphics.method_51430(font, string, left + 5, y, 0xFFFFFF, false);
                    }
                    Objects.requireNonNull(font);
                    y += 9;
                }
            }
        }
    }
}

