/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5489;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.ConnectionData;
import net.minecraftforge.network.NetworkRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class ModMismatchDisconnectedScreen
extends class_437 {
    private final class_2561 reason;
    private class_5489 message = class_5489.field_26528;
    private final class_437 parent;
    private int textHeight;
    private final ConnectionData.ModMismatchData modMismatchData;
    private final Path modsDir;
    private final Path logFile;
    private final int listHeight;
    private final Map<class_2960, Pair<String, String>> presentModData;
    private final List<class_2960> missingModData;
    private final Map<class_2960, String> mismatchedModData;
    private final List<String> allModIds;
    private final Map<String, String> presentModUrls;
    private final boolean mismatchedDataFromServer;

    public ModMismatchDisconnectedScreen(class_437 parentScreen, class_2561 title, class_2561 reason, ConnectionData.ModMismatchData modMismatchData) {
        super(title);
        this.parent = parentScreen;
        this.reason = reason;
        this.modMismatchData = modMismatchData;
        this.modsDir = FMLPaths.MODSDIR.get();
        this.logFile = FMLPaths.GAMEDIR.get().resolve(Paths.get("logs", "latest.log"));
        this.listHeight = modMismatchData.containsMismatches() ? 140 : 0;
        this.mismatchedDataFromServer = modMismatchData.mismatchedDataFromServer();
        this.presentModData = modMismatchData.presentModData();
        this.missingModData = modMismatchData.mismatchedModData().entrySet().stream().filter(e -> ((String)e.getValue()).equals(NetworkRegistry.ABSENT.version())).map(Map.Entry::getKey).collect(Collectors.toList());
        this.mismatchedModData = modMismatchData.mismatchedModData().entrySet().stream().filter(e -> !((String)e.getValue()).equals(NetworkRegistry.ABSENT.version())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.allModIds = this.presentModData.keySet().stream().map(class_2960::method_12836).distinct().collect(Collectors.toList());
        this.presentModUrls = ModList.get().getMods().stream().filter(info -> this.allModIds.contains(info.getModId())).map(info -> Pair.of((Object)info.getModId(), (Object)info.getConfig().getConfigElement(new String[]{"displayURL"}).orElse(""))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    protected void method_25426() {
        this.message = class_5489.method_30890((class_327)this.field_22793, (class_5348)this.reason, (int)(this.field_22789 - 50));
        this.textHeight = this.message.method_30887() * 9;
        int listLeft = Math.max(8, this.field_22789 / 2 - 220);
        int listWidth = Math.min(440, this.field_22789 - 16);
        int upperButtonHeight = Math.min((this.field_22790 + this.listHeight + this.textHeight) / 2 + 10, this.field_22790 - 50);
        int lowerButtonHeight = Math.min((this.field_22790 + this.listHeight + this.textHeight) / 2 + 35, this.field_22790 - 25);
        if (this.modMismatchData.containsMismatches()) {
            this.method_37063((class_364)new MismatchInfoPanel(this.field_22787, listWidth, this.listHeight, (this.field_22790 - this.listHeight) / 2, listLeft));
        }
        int buttonWidth = Math.min(210, this.field_22789 / 2 - 20);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)ForgeI18n.parseMessage("fml.button.open.file", this.logFile.getFileName())), button -> class_156.method_668().method_672(this.logFile.toFile())).method_46434(Math.max(this.field_22789 / 4 - buttonWidth / 2, listLeft), upperButtonHeight, buttonWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)ForgeI18n.parseMessage("fml.button.open.mods.folder", new Object[0])), button -> class_156.method_668().method_672(this.modsDir.toFile())).method_46434(Math.min(this.field_22789 * 3 / 4 - buttonWidth / 2, listLeft + listWidth - buttonWidth), upperButtonHeight, buttonWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.toMenu"), button -> this.field_22787.method_1507(this.parent)).method_46434((this.field_22789 - buttonWidth) / 2, lowerButtonHeight, buttonWidth, 20).method_46431());
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics);
        int textYOffset = this.modMismatchData.containsMismatches() ? 18 : 0;
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, (this.field_22790 - this.listHeight - this.textHeight) / 2 - textYOffset - 18, 0xAAAAAA);
        this.message.method_30888(guiGraphics, this.field_22789 / 2, (this.field_22790 - this.listHeight - this.textHeight) / 2 - textYOffset);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
    }

    class MismatchInfoPanel
    extends ScrollPanel {
        private final List<Pair<class_5481, Pair<class_5481, class_5481>>> lineTable;
        private final int contentSize;
        private final int nameIndent = 10;
        private final int tableWidth;
        private final int nameWidth;
        private final int versionWidth;

        public MismatchInfoPanel(class_310 client, int width, int height, int top, int left) {
            int i;
            super(client, width, height, top, left);
            this.nameIndent = 10;
            this.tableWidth = this.width - this.border * 2 - 6 - 10;
            this.nameWidth = this.tableWidth * 3 / 5;
            this.versionWidth = (this.tableWidth - this.nameWidth) / 2;
            ArrayList<Pair> rawTable = new ArrayList<Pair>();
            if (!ModMismatchDisconnectedScreen.this.missingModData.isEmpty()) {
                rawTable.add(Pair.of((Object)class_2561.method_43470((String)ForgeI18n.parseMessage(ModMismatchDisconnectedScreen.this.mismatchedDataFromServer ? "fml.modmismatchscreen.missingmods.server" : "fml.modmismatchscreen.missingmods.client", new Object[0])).method_27692(class_124.field_1080), null));
                rawTable.add(Pair.of((Object)class_2561.method_43470((String)ForgeI18n.parseMessage("fml.modmismatchscreen.table.modname", new Object[0])).method_27692(class_124.field_1073), (Object)Pair.of((Object)"", (Object)ForgeI18n.parseMessage(ModMismatchDisconnectedScreen.this.mismatchedDataFromServer ? "fml.modmismatchscreen.table.youhave" : "fml.modmismatchscreen.table.youneed", new Object[0]))));
                i = 0;
                for (class_2960 class_29602 : ModMismatchDisconnectedScreen.this.missingModData) {
                    rawTable.add(Pair.of((Object)this.toModNameComponent(class_29602, (String)ModMismatchDisconnectedScreen.this.presentModData.get(class_29602).getLeft(), i), (Object)Pair.of((Object)"", (Object)((String)ModMismatchDisconnectedScreen.this.presentModData.getOrDefault(class_29602, (Pair<String, String>)Pair.of((Object)"", (Object)"")).getRight()))));
                    if (++i < 10) continue;
                    rawTable.add(Pair.of((Object)class_2561.method_43470((String)ForgeI18n.parseMessage("fml.modmismatchscreen.additional", ModMismatchDisconnectedScreen.this.missingModData.size() - i)).method_27692(class_124.field_1056), (Object)Pair.of((Object)"", (Object)"")));
                    break;
                }
                rawTable.add(Pair.of((Object)class_2561.method_43470((String)" "), null));
            }
            if (!ModMismatchDisconnectedScreen.this.mismatchedModData.isEmpty()) {
                rawTable.add(Pair.of((Object)class_2561.method_43470((String)ForgeI18n.parseMessage("fml.modmismatchscreen.mismatchedmods", new Object[0])).method_27692(class_124.field_1080), null));
                rawTable.add(Pair.of((Object)class_2561.method_43470((String)ForgeI18n.parseMessage("fml.modmismatchscreen.table.modname", new Object[0])).method_27692(class_124.field_1073), (Object)Pair.of((Object)ForgeI18n.parseMessage(ModMismatchDisconnectedScreen.this.mismatchedDataFromServer ? "fml.modmismatchscreen.table.youhave" : "fml.modmismatchscreen.table.serverhas", new Object[0]), (Object)ForgeI18n.parseMessage(ModMismatchDisconnectedScreen.this.mismatchedDataFromServer ? "fml.modmismatchscreen.table.serverhas" : "fml.modmismatchscreen.table.youhave", new Object[0]))));
                i = 0;
                for (Map.Entry entry : ModMismatchDisconnectedScreen.this.mismatchedModData.entrySet()) {
                    rawTable.add(Pair.of((Object)this.toModNameComponent((class_2960)entry.getKey(), (String)ModMismatchDisconnectedScreen.this.presentModData.get(entry.getKey()).getLeft(), i), (Object)Pair.of((Object)((String)ModMismatchDisconnectedScreen.this.presentModData.getOrDefault(entry.getKey(), (Pair<String, String>)Pair.of((Object)"", (Object)"")).getRight()), (Object)((String)entry.getValue()))));
                    if (++i < 10) continue;
                    rawTable.add(Pair.of((Object)class_2561.method_43470((String)ForgeI18n.parseMessage("fml.modmismatchscreen.additional", ModMismatchDisconnectedScreen.this.mismatchedModData.size() - i)).method_27692(class_124.field_1056), (Object)Pair.of((Object)"", (Object)"")));
                    break;
                }
                rawTable.add(Pair.of((Object)class_2561.method_43470((String)" "), null));
            }
            this.lineTable = rawTable.stream().flatMap(p -> this.splitLineToWidth((class_5250)p.getKey(), (Pair<String, String>)((Pair)p.getValue())).stream()).collect(Collectors.toList());
            this.contentSize = this.lineTable.size();
        }

        private List<Pair<class_5481, Pair<class_5481, class_5481>>> splitLineToWidth(class_5250 name, Pair<String, String> versions) {
            class_2583 style = name.method_10866();
            int versionColumns = versions == null ? 0 : (((String)versions.getLeft()).isEmpty() ? (((String)versions.getRight()).isEmpty() ? 0 : 1) : 2);
            int adaptedNameWidth = this.nameWidth + this.versionWidth * (2 - versionColumns) - 4;
            List nameLines = ModMismatchDisconnectedScreen.this.field_22793.method_1728((class_5348)name, adaptedNameWidth);
            List clientVersionLines = ModMismatchDisconnectedScreen.this.field_22793.method_1728((class_5348)class_2561.method_43470((String)(versions != null ? (String)versions.getLeft() : "")).method_10862(style), this.versionWidth - 4);
            List serverVersionLines = ModMismatchDisconnectedScreen.this.field_22793.method_1728((class_5348)class_2561.method_43470((String)(versions != null ? (String)versions.getRight() : "")).method_10862(style), this.versionWidth - 4);
            ArrayList<Pair<class_5481, Pair<class_5481, class_5481>>> splitLines = new ArrayList<Pair<class_5481, Pair<class_5481, class_5481>>>();
            int rowsOccupied = Math.max(nameLines.size(), Math.max(clientVersionLines.size(), serverVersionLines.size()));
            for (int i = 0; i < rowsOccupied; ++i) {
                splitLines.add((Pair<class_5481, Pair<class_5481, class_5481>>)Pair.of((Object)(i < nameLines.size() ? (class_5481)nameLines.get(i) : class_5481.field_26385), versions == null ? null : Pair.of((Object)(i < clientVersionLines.size() ? (class_5481)clientVersionLines.get(i) : class_5481.field_26385), (Object)(i < serverVersionLines.size() ? (class_5481)serverVersionLines.get(i) : class_5481.field_26385))));
            }
            return splitLines;
        }

        private class_5250 toModNameComponent(class_2960 id, String modName, int color) {
            String modId = id.method_12836();
            String tooltipId = id.method_12832().isEmpty() ? id.method_12836() : id.toString();
            return class_2561.method_43470((String)modName).method_27692(color % 2 == 0 ? class_124.field_1065 : class_124.field_1054).method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)(tooltipId + (String)(!ModMismatchDisconnectedScreen.this.presentModUrls.getOrDefault(modId, "").isEmpty() ? "\n" + ForgeI18n.parseMessage("fml.modmismatchscreen.homepage", new Object[0]) : "")))))).method_27694(s -> s.method_10958(!ModMismatchDisconnectedScreen.this.presentModUrls.getOrDefault(modId, "").isEmpty() ? new class_2558(class_2558.class_2559.field_11749, ModMismatchDisconnectedScreen.this.presentModUrls.get(modId)) : null));
        }

        @Override
        protected int getContentHeight() {
            Objects.requireNonNull(ModMismatchDisconnectedScreen.this.field_22793);
            int height = this.contentSize * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        @Override
        protected void drawPanel(class_332 guiGraphics, int entryRight, int relativeY, class_289 tess, int mouseX, int mouseY) {
            int i = 0;
            for (Pair<class_5481, Pair<class_5481, class_5481>> line : this.lineTable) {
                class_5481 name = (class_5481)line.getLeft();
                Pair versions = (Pair)line.getRight();
                int color = Optional.ofNullable(ModMismatchDisconnectedScreen.this.field_22793.method_27527().method_30876(name, 0)).map(class_2583::method_10973).map(class_5251::method_27716).orElse(0xFFFFFF);
                int nameLeft = this.left + this.border + (versions == null ? 0 : 10);
                guiGraphics.method_51430(ModMismatchDisconnectedScreen.this.field_22793, name, nameLeft, relativeY + i * 12, color, false);
                if (versions != null) {
                    guiGraphics.method_51430(ModMismatchDisconnectedScreen.this.field_22793, (class_5481)versions.getLeft(), this.left + this.border + 10 + this.nameWidth, relativeY + i * 12, color, false);
                    guiGraphics.method_51430(ModMismatchDisconnectedScreen.this.field_22793, (class_5481)versions.getRight(), this.left + this.border + 10 + this.nameWidth + this.versionWidth, relativeY + i * 12, color, false);
                }
                ++i;
            }
        }

        @Override
        public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
            class_2583 style = this.getComponentStyleAt(mouseX, mouseY);
            if (style != null && style.method_10969() != null) {
                guiGraphics.method_51441(ModMismatchDisconnectedScreen.this.field_22793, style, mouseX, mouseY);
            }
        }

        public class_2583 getComponentStyleAt(double x, double y) {
            double relativeX;
            double relativeY;
            int slotIndex;
            if (this.method_25405(x, y) && (slotIndex = (int)((relativeY = y - (double)this.top + (double)this.scrollDistance - (double)this.border) + (double)(this.border / 2)) / 12) < this.contentSize && (relativeX = x - (double)this.left - (double)this.border - (double)(this.lineTable.get(slotIndex).getRight() == null ? 0 : 10)) >= 0.0) {
                return ModMismatchDisconnectedScreen.this.field_22793.method_27527().method_30876((class_5481)this.lineTable.get(slotIndex).getLeft(), (int)relativeX);
            }
            return null;
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            class_2583 style = this.getComponentStyleAt(mouseX, mouseY);
            if (style != null) {
                ModMismatchDisconnectedScreen.this.method_25430(style);
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33784;
        }

        public void method_37020(class_6382 output) {
        }
    }
}

