/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui.overlay;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class GuiOverlayManager {
    private static ImmutableList<NamedGuiOverlay> OVERLAYS;
    private static ImmutableMap<class_2960, NamedGuiOverlay> OVERLAYS_BY_NAME;

    public static ImmutableList<NamedGuiOverlay> getOverlays() {
        return OVERLAYS;
    }

    @Nullable
    public static NamedGuiOverlay findOverlay(class_2960 id) {
        return (NamedGuiOverlay)OVERLAYS_BY_NAME.get((Object)id);
    }

    @ApiStatus.Internal
    public static void init() {
        HashMap<class_2960, IGuiOverlay> overlays = new HashMap<class_2960, IGuiOverlay>();
        ArrayList<class_2960> orderedOverlays = new ArrayList<class_2960>();
        GuiOverlayManager.preRegisterVanillaOverlays(overlays, orderedOverlays);
        RegisterGuiOverlaysEvent event = new RegisterGuiOverlaysEvent(overlays, orderedOverlays);
        ModLoader.get().postEventWrapContainerInModOrder(event);
        OVERLAYS = (ImmutableList)orderedOverlays.stream().map(id -> new NamedGuiOverlay((class_2960)id, (IGuiOverlay)overlays.get(id))).collect(ImmutableList.toImmutableList());
        OVERLAYS_BY_NAME = (ImmutableMap)OVERLAYS.stream().collect(ImmutableMap.toImmutableMap(NamedGuiOverlay::id, Function.identity()));
        GuiOverlayManager.assignVanillaOverlayTypes();
    }

    private static void preRegisterVanillaOverlays(HashMap<class_2960, IGuiOverlay> overlays, ArrayList<class_2960> orderedOverlays) {
        for (VanillaGuiOverlay entry : VanillaGuiOverlay.values()) {
            overlays.put(entry.id(), (gui, guiGraphics, partialTick, width, height) -> {});
            orderedOverlays.add(entry.id());
        }
    }

    private static void assignVanillaOverlayTypes() {
        for (VanillaGuiOverlay entry : VanillaGuiOverlay.values()) {
            entry.type = (NamedGuiOverlay)OVERLAYS_BY_NAME.get((Object)entry.id());
        }
    }

    private GuiOverlayManager() {
    }
}

