/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.common.util.ConcatenatedListView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeModel
implements IUnbakedGeometry<CompositeModel> {
    private final ImmutableMap<String, class_793> children;
    private final ImmutableList<String> itemPasses;

    public CompositeModel(ImmutableMap<String, class_793> children, ImmutableList<String> itemPasses) {
        this.children = children;
        this.itemPasses = itemPasses;
    }

    @Override
    public class_1087 bake(IGeometryBakingContext context, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_806 overrides, class_2960 modelLocation) {
        class_4730 particleLocation = context.getMaterial("particle");
        class_1058 particle = spriteGetter.apply(particleLocation);
        class_4590 rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = UnbakedGeometryHelper.composeRootTransformIntoModelState(modelState, rootTransform);
        }
        ImmutableMap.Builder bakedPartsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.children.entrySet()) {
            String name = (String)entry.getKey();
            if (!context.isComponentVisible(name, true)) continue;
            class_793 model = (class_793)entry.getValue();
            bakedPartsBuilder.put((Object)name, (Object)UnbakedGeometryHelper.bake(model, baker, model, spriteGetter, modelState, modelLocation, true));
        }
        ImmutableMap bakedParts = bakedPartsBuilder.build();
        ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
        for (String name : this.itemPasses) {
            class_1087 model = (class_1087)bakedParts.get((Object)name);
            if (model == null) {
                throw new IllegalStateException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
            }
            itemPassesBuilder.add((Object)model);
        }
        return new Baked(context.isGui3d(), context.useBlockLight(), context.useAmbientOcclusion(), particle, context.getTransforms(), overrides, (ImmutableMap<String, class_1087>)bakedParts, (ImmutableList<class_1087>)itemPassesBuilder.build());
    }

    @Override
    public void resolveParents(Function<class_2960, class_1100> modelGetter, IGeometryBakingContext context) {
        this.children.values().forEach(child -> child.method_45785(modelGetter));
    }

    @Override
    public Set<String> getConfigurableComponentNames() {
        return this.children.keySet();
    }

    public static class Baked
    implements IDynamicBakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final class_1058 particle;
        private final class_806 overrides;
        private final class_809 transforms;
        private final ImmutableMap<String, class_1087> children;
        private final ImmutableList<class_1087> itemPasses;

        public Baked(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, class_1058 particle, class_809 transforms, class_806 overrides, ImmutableMap<String, class_1087> children, ImmutableList<class_1087> itemPasses) {
            this.children = children;
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = overrides;
            this.transforms = transforms;
            this.itemPasses = itemPasses;
        }

        @Override
        @NotNull
        public List<class_777> getQuads(@Nullable class_2680 state, @Nullable class_2350 side, @NotNull class_5819 rand, @NotNull ModelData data, @Nullable class_1921 renderType) {
            ArrayList<List> quadLists = new ArrayList<List>();
            for (Map.Entry entry : this.children.entrySet()) {
                if (renderType != null && (state == null || !((class_1087)entry.getValue()).getRenderTypes(state, rand, data).contains(renderType))) continue;
                quadLists.add(((class_1087)entry.getValue()).getQuads(state, side, rand, Data.resolve(data, (String)entry.getKey()), renderType));
            }
            return ConcatenatedListView.of(quadLists);
        }

        @NotNull
        public ModelData getModelData(@NotNull class_1920 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull ModelData modelData) {
            Data.Builder builder = Data.builder();
            for (Map.Entry entry : this.children.entrySet()) {
                builder.with((String)entry.getKey(), ((class_1087)entry.getValue()).getModelData(level, pos, state, Data.resolve(modelData, (String)entry.getKey())));
            }
            return modelData.derive().with(Data.PROPERTY, builder.build()).build();
        }

        public boolean method_4708() {
            return this.isAmbientOcclusion;
        }

        public boolean method_4712() {
            return this.isGui3d;
        }

        public boolean method_24304() {
            return this.isSideLit;
        }

        public boolean method_4713() {
            return false;
        }

        public class_1058 method_4711() {
            return this.particle;
        }

        public class_806 method_4710() {
            return this.overrides;
        }

        public class_809 method_4709() {
            return this.transforms;
        }

        public ChunkRenderTypeSet getRenderTypes(@NotNull class_2680 state, @NotNull class_5819 rand, @NotNull ModelData data) {
            ArrayList<ChunkRenderTypeSet> sets = new ArrayList<ChunkRenderTypeSet>();
            for (Map.Entry entry : this.children.entrySet()) {
                sets.add(((class_1087)entry.getValue()).getRenderTypes(state, rand, Data.resolve(data, (String)entry.getKey())));
            }
            return ChunkRenderTypeSet.union(sets);
        }

        public List<class_1087> getRenderPasses(class_1799 itemStack, boolean fabulous) {
            return this.itemPasses;
        }

        @Nullable
        public class_1087 getPart(String name) {
            return (class_1087)this.children.get((Object)name);
        }

        public static Builder builder(IGeometryBakingContext owner, class_1058 particle, class_806 overrides, class_809 cameraTransforms) {
            return Baked.builder(owner.useAmbientOcclusion(), owner.isGui3d(), owner.useBlockLight(), particle, overrides, cameraTransforms);
        }

        public static Builder builder(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, class_1058 particle, class_806 overrides, class_809 cameraTransforms) {
            return new Builder(isAmbientOcclusion, isGui3d, isSideLit, particle, overrides, cameraTransforms);
        }

        public static class Builder {
            private final boolean isAmbientOcclusion;
            private final boolean isGui3d;
            private final boolean isSideLit;
            private final List<class_1087> children = new ArrayList<class_1087>();
            private final List<class_777> quads = new ArrayList<class_777>();
            private final class_806 overrides;
            private final class_809 transforms;
            private class_1058 particle;
            private RenderTypeGroup lastRenderTypes = RenderTypeGroup.EMPTY;
            private RenderTypeGroup lastRenderTypesFast = RenderTypeGroup.EMPTY;

            private Builder(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, class_1058 particle, class_806 overrides, class_809 transforms) {
                this.isAmbientOcclusion = isAmbientOcclusion;
                this.isGui3d = isGui3d;
                this.isSideLit = isSideLit;
                this.particle = particle;
                this.overrides = overrides;
                this.transforms = transforms;
            }

            public void addLayer(class_1087 model) {
                this.flushQuads(RenderTypeGroup.EMPTY, RenderTypeGroup.EMPTY);
                this.children.add(model);
            }

            private void addLayer(RenderTypeGroup renderTypes, List<class_777> quads) {
                this.addLayer(renderTypes, RenderTypeGroup.EMPTY, quads);
            }

            private void addLayer(RenderTypeGroup renderTypes, RenderTypeGroup renderTypesFast, List<class_777> quads) {
                IModelBuilder<?> modelBuilder = IModelBuilder.of(this.isAmbientOcclusion, this.isSideLit, this.isGui3d, this.transforms, this.overrides, this.particle, renderTypes, renderTypesFast);
                quads.forEach(modelBuilder::addUnculledFace);
                this.children.add(modelBuilder.build());
            }

            private void flushQuads(RenderTypeGroup renderTypes) {
                this.flushQuads(renderTypes, RenderTypeGroup.EMPTY);
            }

            private void flushQuads(RenderTypeGroup renderTypes, RenderTypeGroup renderTypesFast) {
                if (!Objects.equals(renderTypes, this.lastRenderTypes)) {
                    if (this.quads.size() > 0) {
                        this.addLayer(this.lastRenderTypes, this.lastRenderTypesFast, this.quads);
                        this.quads.clear();
                    }
                    this.lastRenderTypes = renderTypes;
                    this.lastRenderTypesFast = renderTypesFast;
                }
            }

            public Builder setParticle(class_1058 particleSprite) {
                this.particle = particleSprite;
                return this;
            }

            public Builder addQuads(RenderTypeGroup renderTypes, class_777 ... quadsToAdd) {
                return this.addQuads(renderTypes, RenderTypeGroup.EMPTY, quadsToAdd);
            }

            public Builder addQuads(RenderTypeGroup renderTypes, RenderTypeGroup renderTypesFast, class_777 ... quadsToAdd) {
                this.flushQuads(renderTypes, renderTypesFast);
                Collections.addAll(this.quads, quadsToAdd);
                return this;
            }

            public Builder addQuads(RenderTypeGroup renderTypes, Collection<class_777> quadsToAdd) {
                return this.addQuads(renderTypes, RenderTypeGroup.EMPTY, quadsToAdd);
            }

            public Builder addQuads(RenderTypeGroup renderTypes, RenderTypeGroup renderTypesFast, Collection<class_777> quadsToAdd) {
                this.flushQuads(renderTypes, renderTypesFast);
                this.quads.addAll(quadsToAdd);
                return this;
            }

            public class_1087 build() {
                if (this.quads.size() > 0) {
                    this.addLayer(this.lastRenderTypes, this.lastRenderTypesFast, this.quads);
                }
                ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
                ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
                int i = 0;
                for (class_1087 model : this.children) {
                    childrenBuilder.put((Object)("model_" + i++), (Object)model);
                    itemPassesBuilder.add((Object)model);
                }
                return new Baked(this.isGui3d, this.isSideLit, this.isAmbientOcclusion, this.particle, this.transforms, this.overrides, (ImmutableMap<String, class_1087>)childrenBuilder.build(), (ImmutableList<class_1087>)itemPassesBuilder.build());
            }
        }
    }

    public static final class Loader
    implements IGeometryLoader<CompositeModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public CompositeModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            ArrayList<String> itemPasses = new ArrayList<String>();
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            this.readChildren(jsonObject, "children", deserializationContext, (ImmutableMap.Builder<String, class_793>)childrenBuilder, itemPasses);
            ImmutableMap children = childrenBuilder.build();
            if (children.isEmpty()) {
                throw new JsonParseException("Composite model requires a \"children\" element with at least one element.");
            }
            if (jsonObject.has("item_render_order")) {
                itemPasses.clear();
                for (JsonElement element : jsonObject.getAsJsonArray("item_render_order")) {
                    String name = element.getAsString();
                    if (!children.containsKey((Object)name)) {
                        throw new JsonParseException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
                    }
                    itemPasses.add(name);
                }
            }
            return new CompositeModel((ImmutableMap<String, class_793>)children, (ImmutableList<String>)ImmutableList.copyOf(itemPasses));
        }

        private void readChildren(JsonObject jsonObject, String name, JsonDeserializationContext deserializationContext, ImmutableMap.Builder<String, class_793> children, List<String> itemPasses) {
            if (!jsonObject.has(name)) {
                return;
            }
            JsonObject childrenJsonObject = jsonObject.getAsJsonObject(name);
            for (Map.Entry entry : childrenJsonObject.entrySet()) {
                children.put((Object)((String)entry.getKey()), (Object)((class_793)deserializationContext.deserialize((JsonElement)entry.getValue(), class_793.class)));
                itemPasses.add((String)entry.getKey());
            }
        }
    }

    public static class Data {
        public static final ModelProperty<Data> PROPERTY = new ModelProperty();
        private final Map<String, ModelData> partData;

        private Data(Map<String, ModelData> partData) {
            this.partData = partData;
        }

        @Nullable
        public ModelData get(String name) {
            return this.partData.get(name);
        }

        public static ModelData resolve(ModelData modelData, String name) {
            Data compositeData = modelData.get(PROPERTY);
            if (compositeData == null) {
                return modelData;
            }
            ModelData partData = compositeData.get(name);
            return partData != null ? partData : modelData;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private final Map<String, ModelData> partData = new IdentityHashMap<String, ModelData>();

            public Builder with(String name, ModelData data) {
                this.partData.put(name, data);
                return this;
            }

            public Data build() {
                return new Data(this.partData);
            }
        }
    }
}

