/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.SimpleUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;

public class ElementsModel
extends SimpleUnbakedGeometry<ElementsModel> {
    private final List<class_785> elements;

    public ElementsModel(List<class_785> elements) {
        this.elements = elements;
    }

    @Override
    protected void addQuads(IGeometryBakingContext context, IModelBuilder<?> modelBuilder, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_2960 modelLocation) {
        IQuadTransformer postTransform = QuadTransformers.empty();
        class_4590 rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            postTransform = UnbakedGeometryHelper.applyRootTransform(modelState, rootTransform);
        }
        for (class_785 element : this.elements) {
            for (class_2350 direction : element.field_4230.keySet()) {
                class_783 face = (class_783)element.field_4230.get(direction);
                class_1058 sprite = spriteGetter.apply(context.getMaterial(face.field_4224));
                class_777 quad = class_793.method_3447((class_785)element, (class_783)face, (class_1058)sprite, (class_2350)direction, (class_3665)modelState, (class_2960)modelLocation);
                postTransform.processInPlace(quad);
                if (face.field_4225 == null) {
                    modelBuilder.addUnculledFace(quad);
                    continue;
                }
                modelBuilder.addCulledFace(modelState.method_3509().rotateTransform(face.field_4225), quad);
            }
        }
    }

    public static final class Loader
    implements IGeometryLoader<ElementsModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public ElementsModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            if (!jsonObject.has("elements")) {
                throw new JsonParseException("An element model must have an \"elements\" member.");
            }
            ArrayList<class_785> elements = new ArrayList<class_785>();
            for (JsonElement element : class_3518.method_15261((JsonObject)jsonObject, (String)"elements")) {
                elements.add((class_785)deserializationContext.deserialize(element, class_785.class));
            }
            return new ElementsModel(elements);
        }
    }
}

