/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_785;
import net.minecraft.class_806;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.ForgeFaceData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;

public class ItemLayerModel
implements IUnbakedGeometry<ItemLayerModel> {
    @Nullable
    private ImmutableList<class_4730> textures;
    private final Int2ObjectMap<ForgeFaceData> layerData;
    private final Int2ObjectMap<class_2960> renderTypeNames;
    private final Int2ObjectMap<class_2960> renderTypeNamesFast;

    private ItemLayerModel(@Nullable ImmutableList<class_4730> textures, Int2ObjectMap<ForgeFaceData> layerData, Int2ObjectMap<class_2960> renderTypeNames) {
        this(textures, layerData, renderTypeNames, (Int2ObjectMap<class_2960>)new Int2ObjectOpenHashMap());
    }

    private ItemLayerModel(@Nullable ImmutableList<class_4730> textures, Int2ObjectMap<ForgeFaceData> layerData, Int2ObjectMap<class_2960> renderTypeNames, Int2ObjectMap<class_2960> renderTypeNamesFast) {
        this.textures = textures;
        this.layerData = layerData;
        this.renderTypeNames = renderTypeNames;
        this.renderTypeNamesFast = renderTypeNamesFast;
    }

    @Override
    public class_1087 bake(IGeometryBakingContext context, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_806 overrides, class_2960 modelLocation) {
        if (this.textures == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            int i = 0;
            while (context.hasMaterial("layer" + i)) {
                builder.add((Object)context.getMaterial("layer" + i));
                ++i;
            }
            this.textures = builder.build();
        }
        class_1058 particle = spriteGetter.apply(context.hasMaterial("particle") ? context.getMaterial("particle") : (class_4730)this.textures.get(0));
        class_4590 rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = UnbakedGeometryHelper.composeRootTransformIntoModelState(modelState, rootTransform);
        }
        RenderTypeGroup normalRenderTypes = new RenderTypeGroup(class_1921.method_23583(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder(context, particle, overrides, context.getTransforms());
        for (int i = 0; i < this.textures.size(); ++i) {
            class_1058 sprite = spriteGetter.apply((class_4730)this.textures.get(i));
            List<class_785> unbaked = UnbakedGeometryHelper.createUnbakedItemElements(i, sprite.method_45851(), (ForgeFaceData)this.layerData.get(i));
            List<class_777> quads = UnbakedGeometryHelper.bakeElements(unbaked, $ -> sprite, modelState, modelLocation);
            class_2960 renderTypeName = (class_2960)this.renderTypeNames.get(i);
            RenderTypeGroup renderTypes = renderTypeName != null ? context.getRenderType(renderTypeName) : null;
            class_2960 renderTypeNameFast = (class_2960)this.renderTypeNamesFast.get(i);
            RenderTypeGroup renderTypesFast = renderTypeNameFast != null ? context.getRenderType(renderTypeNameFast) : null;
            builder.addQuads(renderTypes != null ? renderTypes : normalRenderTypes, renderTypesFast != null ? renderTypesFast : RenderTypeGroup.EMPTY, quads);
        }
        return builder.build();
    }

    public static final class Loader
    implements IGeometryLoader<ItemLayerModel> {
        public static final Loader INSTANCE = new Loader();

        @Override
        public ItemLayerModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            Int2ObjectOpenHashMap renderTypeNames = new Int2ObjectOpenHashMap();
            if (jsonObject.has("render_types")) {
                JsonObject renderTypes = jsonObject.getAsJsonObject("render_types");
                for (Object entry : renderTypes.entrySet()) {
                    class_2960 renderType = new class_2960((String)entry.getKey());
                    for (JsonElement layer : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (renderTypeNames.put(layer.getAsInt(), (Object)renderType) == null) continue;
                        throw new JsonParseException("Registered duplicate render type for layer " + String.valueOf(layer));
                    }
                }
            }
            Int2ObjectOpenHashMap renderTypeNamesFast = new Int2ObjectOpenHashMap();
            if (jsonObject.has("render_types_fast")) {
                JsonObject renderTypes = jsonObject.getAsJsonObject("render_types_fast");
                for (Map.Entry entry : renderTypes.entrySet()) {
                    class_2960 renderType = new class_2960((String)entry.getKey());
                    for (JsonElement layer : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (renderTypeNamesFast.put(layer.getAsInt(), (Object)renderType) == null) continue;
                        throw new JsonParseException("Registered duplicate fast graphics render type for layer " + String.valueOf(layer));
                    }
                }
            }
            Int2ObjectArrayMap emissiveLayers = new Int2ObjectArrayMap();
            if (jsonObject.has("forge_data")) {
                JsonObject forgeData = jsonObject.get("forge_data").getAsJsonObject();
                this.readLayerData(forgeData, "layers", (Int2ObjectOpenHashMap<class_2960>)renderTypeNames, (Int2ObjectOpenHashMap<class_2960>)renderTypeNamesFast, (Int2ObjectMap<ForgeFaceData>)emissiveLayers, false);
            }
            return new ItemLayerModel(null, (Int2ObjectMap<ForgeFaceData>)emissiveLayers, (Int2ObjectMap<class_2960>)renderTypeNames, (Int2ObjectMap<class_2960>)renderTypeNamesFast);
        }

        protected void readLayerData(JsonObject jsonObject, String name, Int2ObjectOpenHashMap<class_2960> renderTypeNames, Int2ObjectMap<ForgeFaceData> layerData, boolean logWarning) {
            this.readLayerData(jsonObject, name, renderTypeNames, (Int2ObjectOpenHashMap<class_2960>)new Int2ObjectOpenHashMap(), layerData, logWarning);
        }

        @Deprecated(forRemoval=true, since="1.21.4")
        protected void readLayerData(JsonObject jsonObject, String name, Int2ObjectOpenHashMap<class_2960> renderTypeNames, Int2ObjectOpenHashMap<class_2960> renderTypeNamesFast, Int2ObjectMap<ForgeFaceData> layerData, boolean logWarning) {
            if (!jsonObject.has(name)) {
                return;
            }
            JsonObject fullbrightLayers = jsonObject.getAsJsonObject(name);
            for (Map.Entry entry : fullbrightLayers.entrySet()) {
                int layer = Integer.parseInt((String)entry.getKey());
                ForgeFaceData data = ForgeFaceData.read((JsonElement)entry.getValue(), ForgeFaceData.DEFAULT);
                layerData.put(layer, (Object)data);
            }
        }
    }
}

