/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.data;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="forge", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
@ApiStatus.Internal
public class ModelDataManager {
    private final class_1937 level;
    private final Map<class_1923, Set<class_2338>> needModelDataRefresh = new ConcurrentHashMap<class_1923, Set<class_2338>>();
    private final Map<class_1923, Map<class_2338, ModelData>> modelDataCache = new ConcurrentHashMap<class_1923, Map<class_2338, ModelData>>();

    public ModelDataManager(class_1937 level) {
        this.level = level;
    }

    public void requestRefresh(@NotNull class_2586 blockEntity) {
        Preconditions.checkNotNull((Object)blockEntity, (Object)"Block entity must not be null");
        this.needModelDataRefresh.computeIfAbsent(new class_1923(blockEntity.method_11016()), $ -> Collections.newSetFromMap(new ConcurrentHashMap())).add(blockEntity.method_11016());
    }

    private void refreshAt(class_1923 chunk) {
        Set<class_2338> needUpdate = this.needModelDataRefresh.remove(chunk);
        if (needUpdate != null) {
            Map data = this.modelDataCache.computeIfAbsent(chunk, $ -> new ConcurrentHashMap());
            for (class_2338 pos : needUpdate) {
                class_2586 toUpdate = this.level.getExistingBlockEntity(pos);
                if (toUpdate != null && !toUpdate.method_11015()) {
                    data.put(pos, toUpdate.getModelData());
                    continue;
                }
                data.remove(pos);
            }
        }
    }

    @Nullable
    public ModelData getAt(class_2338 pos) {
        return this.getAt(new class_1923(pos)).get(pos);
    }

    public Map<class_2338, ModelData> getAt(class_1923 pos) {
        Preconditions.checkArgument((boolean)this.level.field_9236, (Object)"Cannot request model data for server level");
        this.refreshAt(pos);
        return this.modelDataCache.getOrDefault(pos, Collections.emptyMap());
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        class_1936 level = event.getChunk().getWorldForge();
        if (level == null) {
            return;
        }
        ModelDataManager modelDataManager = level.getModelDataManager();
        if (modelDataManager == null) {
            return;
        }
        class_1923 chunk = event.getChunk().method_12004();
        modelDataManager.needModelDataRefresh.remove(chunk);
        modelDataManager.modelDataCache.remove(chunk);
    }
}

