/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.data;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_1087;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class MultipartModelData {
    public static final ModelProperty<MultipartModelData> PROPERTY = new ModelProperty();
    private final Map<class_1087, ModelData> partData;

    private MultipartModelData(Map<class_1087, ModelData> partData) {
        this.partData = partData;
    }

    @Nullable
    public ModelData get(class_1087 model) {
        return this.partData.get(model);
    }

    public static ModelData resolve(ModelData modelData, class_1087 model) {
        MultipartModelData multipartData = modelData.get(PROPERTY);
        if (multipartData == null) {
            return modelData;
        }
        ModelData partData = multipartData.get(model);
        return partData != null ? partData : modelData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<class_1087, ModelData> partData = new IdentityHashMap<class_1087, ModelData>();

        public Builder with(class_1087 model, ModelData data) {
            this.partData.put(model, data);
            return this;
        }

        public MultipartModelData build() {
            return new MultipartModelData(this.partData);
        }
    }
}

