/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.geometry;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1090;
import net.minecraft.class_156;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_7764;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;
import net.minecraft.class_793;
import net.minecraft.class_796;
import net.minecraft.class_801;
import net.minecraftforge.client.model.ElementsModel;
import net.minecraftforge.client.model.ForgeFaceData;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import xyz.bluspring.kilt.injections.client.renderer.block.model.BlockElementInjection;
import xyz.bluspring.kilt.injections.client.renderer.block.model.BlockModelInjection;

public class UnbakedGeometryHelper {
    private static final class_801 ITEM_MODEL_GENERATOR = new class_801();
    private static final class_796 FACE_BAKERY = new class_796();
    private static final Pattern FILESYSTEM_PATH_TO_RESLOC = Pattern.compile("(?:.*[\\\\/]assets[\\\\/](?<namespace>[a-z_-]+)[\\\\/]textures[\\\\/])?(?<path>[a-z_\\\\/-]+)\\.png");

    public static class_4730 resolveDirtyMaterial(@Nullable String tex, IGeometryBakingContext owner) {
        if (tex == null) {
            return new class_4730(class_1059.field_5275, class_1047.method_4539());
        }
        if (tex.startsWith("#")) {
            return owner.getMaterial(tex);
        }
        Matcher match = FILESYSTEM_PATH_TO_RESLOC.matcher(tex);
        if (match.matches()) {
            String namespace = match.group("namespace");
            String path = match.group("path").replace("\\", "/");
            tex = namespace != null ? namespace + ":" + path : path;
        }
        return new class_4730(class_1059.field_5275, new class_2960(tex));
    }

    @ApiStatus.Internal
    public static class_1087 bake(class_793 blockModel, class_7775 modelBaker, class_793 owner, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_2960 modelLocation, boolean guiLight3d) {
        IUnbakedGeometry<?> customModel = ((BlockModelInjection)blockModel).kilt$getCustomData().getCustomGeometry();
        if (customModel != null) {
            return customModel.bake(((BlockModelInjection)blockModel).kilt$getCustomData(), modelBaker, spriteGetter, modelState, blockModel.getOverrides(modelBaker, owner, spriteGetter), modelLocation);
        }
        if (blockModel.method_3431() == class_1088.field_5400) {
            return ITEM_MODEL_GENERATOR.method_3479(spriteGetter, blockModel).method_3446(modelBaker, blockModel, spriteGetter, modelState, modelLocation, guiLight3d);
        }
        if (blockModel.method_3431() == class_1088.field_5389) {
            class_1058 particleSprite = spriteGetter.apply(blockModel.method_24077("particle"));
            return new class_1090(blockModel.method_3443(), blockModel.getOverrides(modelBaker, owner, spriteGetter), particleSprite, blockModel.method_24298().method_24299());
        }
        ElementsModel elementsModel = new ElementsModel(blockModel.method_3433());
        return elementsModel.bake(((BlockModelInjection)blockModel).kilt$getCustomData(), modelBaker, spriteGetter, modelState, blockModel.getOverrides(modelBaker, owner, spriteGetter), modelLocation);
    }

    public static List<class_785> createUnbakedItemElements(int layerIndex, class_7764 spriteContents) {
        return UnbakedGeometryHelper.createUnbakedItemElements(layerIndex, spriteContents, null);
    }

    public static List<class_785> createUnbakedItemElements(int layerIndex, class_7764 spriteContents, @Nullable ForgeFaceData faceData) {
        List elements = ITEM_MODEL_GENERATOR.method_3480(layerIndex, "layer" + layerIndex, spriteContents);
        if (faceData != null) {
            elements.forEach(element -> ((BlockElementInjection)element).setFaceData(faceData));
        }
        return elements;
    }

    public static List<class_785> createUnbakedItemMaskElements(int layerIndex, class_7764 spriteContents) {
        return UnbakedGeometryHelper.createUnbakedItemMaskElements(layerIndex, spriteContents, null);
    }

    public static List<class_785> createUnbakedItemMaskElements(int layerIndex, class_7764 spriteContents, @Nullable ForgeFaceData faceData) {
        List<class_785> elements = UnbakedGeometryHelper.createUnbakedItemElements(layerIndex, spriteContents, faceData);
        elements.remove(0);
        int width = spriteContents.method_45807();
        int height = spriteContents.method_45815();
        BitSet bits = new BitSet(width * height);
        spriteContents.method_45817().forEach(frame -> {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (spriteContents.method_45810(frame, x, y)) continue;
                    bits.set(x + y * width);
                }
            }
        });
        for (int y = 0; y < height; ++y) {
            int xStart = -1;
            for (int x = 0; x < width; ++x) {
                int yEnd;
                boolean opaque = bits.get(x + y * width);
                if (opaque != (xStart == -1)) continue;
                if (xStart == -1) {
                    xStart = x;
                    continue;
                }
                block2: for (yEnd = y + 1; yEnd < height; ++yEnd) {
                    for (int x2 = xStart; x2 <= x; ++x2) {
                        if (!bits.get(x2 + yEnd * width)) break block2;
                    }
                }
                for (int i = xStart; i < x; ++i) {
                    for (int j = y; j < yEnd; ++j) {
                        bits.clear(i + j * width);
                    }
                }
                elements.add(new class_785(new Vector3f((float)(16 * xStart) / (float)width, 16.0f - (float)(16 * yEnd) / (float)height, 7.5f), new Vector3f((float)(16 * x) / (float)width, 16.0f - (float)(16 * y) / (float)height, 8.5f), (Map)class_156.method_654(new HashMap(), map -> {
                    for (class_2350 direction : class_2350.values()) {
                        map.put(direction, new class_783(null, layerIndex, "layer" + layerIndex, new class_787(null, 0)));
                    }
                }), null, true));
                xStart = -1;
            }
        }
        return elements;
    }

    public static void bakeElements(IModelBuilder<?> builder, List<class_785> elements, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_2960 modelLocation) {
        for (class_785 element : elements) {
            element.field_4230.forEach((side, face) -> {
                class_1058 sprite = (class_1058)spriteGetter.apply(new class_4730(class_1059.field_5275, new class_2960(face.field_4224)));
                class_777 quad = UnbakedGeometryHelper.bakeElementFace(element, face, sprite, side, modelState, modelLocation);
                if (face.field_4225 == null) {
                    builder.addUnculledFace(quad);
                } else {
                    builder.addCulledFace(class_2350.method_23225((Matrix4f)modelState.method_3509().method_22936(), (class_2350)face.field_4225), quad);
                }
            });
        }
    }

    public static List<class_777> bakeElements(List<class_785> elements, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_2960 modelLocation) {
        if (elements.isEmpty()) {
            return List.of();
        }
        ArrayList<class_777> list = new ArrayList<class_777>();
        UnbakedGeometryHelper.bakeElements(IModelBuilder.collecting(list), elements, spriteGetter, modelState, modelLocation);
        return list;
    }

    public static class_777 bakeElementFace(class_785 element, class_783 face, class_1058 sprite, class_2350 direction, class_3665 state, class_2960 modelLocation) {
        return FACE_BAKERY.method_3468(element.field_4228, element.field_4231, face, sprite, direction, state, element.field_4232, element.field_4229, modelLocation);
    }

    public static IQuadTransformer applyRootTransform(class_3665 modelState, class_4590 rootTransform) {
        class_4590 transform = modelState.method_3509().applyOrigin(new Vector3f(0.5f, 0.5f, 0.5f));
        return QuadTransformers.applying(transform.method_22933(rootTransform).method_22933(transform.method_22935()));
    }

    public static class_3665 composeRootTransformIntoModelState(class_3665 modelState, class_4590 rootTransform) {
        rootTransform = rootTransform.applyOrigin(new Vector3f(-0.5f, -0.5f, -0.5f));
        return new SimpleModelState(modelState.method_3509().method_22933(rootTransform), modelState.method_3512());
    }
}

