/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.lighting;

import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_778;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.lighting.FlatQuadLighter;
import net.minecraftforge.client.model.lighting.QuadLighter;
import net.minecraftforge.client.model.lighting.SmoothQuadLighter;
import net.minecraftforge.common.ForgeConfig;
import xyz.bluspring.kilt.injections.client.renderer.block.ModelBlockRendererInjection;
import xyz.bluspring.kilt.injections.client.renderer.block.model.BakedQuadInjection;

public class ForgeModelBlockRenderer
extends class_778
implements ModelBlockRendererInjection {
    private static final class_2350[] SIDES = class_2350.values();
    private final ThreadLocal<QuadLighter> flatLighter = ThreadLocal.withInitial(() -> new FlatQuadLighter(colors));
    private final ThreadLocal<QuadLighter> smoothLighter = ThreadLocal.withInitial(() -> new SmoothQuadLighter(colors));

    public ForgeModelBlockRenderer(class_324 colors) {
        super(colors);
    }

    @Override
    public void tesselateWithoutAO(class_1920 level, class_1087 model, class_2680 state, class_2338 pos, class_4587 poseStack, class_4588 vertexConsumer, boolean checkSides, class_5819 rand, long seed, int packedOverlay, ModelData modelData, class_1921 renderType) {
        if (((Boolean)ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get()).booleanValue()) {
            ForgeModelBlockRenderer.render(vertexConsumer, this.flatLighter.get(), level, model, state, pos, poseStack, checkSides, rand, seed, packedOverlay, modelData, renderType);
        } else {
            ModelBlockRendererInjection.super.tesselateWithoutAO(level, model, state, pos, poseStack, vertexConsumer, checkSides, rand, seed, packedOverlay, modelData, renderType);
        }
    }

    @Override
    public void tesselateWithAO(class_1920 level, class_1087 model, class_2680 state, class_2338 pos, class_4587 poseStack, class_4588 vertexConsumer, boolean checkSides, class_5819 rand, long seed, int packedOverlay, ModelData modelData, class_1921 renderType) {
        if (((Boolean)ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get()).booleanValue()) {
            ForgeModelBlockRenderer.render(vertexConsumer, this.smoothLighter.get(), level, model, state, pos, poseStack, checkSides, rand, seed, packedOverlay, modelData, renderType);
        } else {
            ModelBlockRendererInjection.super.tesselateWithAO(level, model, state, pos, poseStack, vertexConsumer, checkSides, rand, seed, packedOverlay, modelData, renderType);
        }
    }

    public static boolean render(class_4588 vertexConsumer, QuadLighter lighter, class_1920 level, class_1087 model, class_2680 state, class_2338 pos, class_4587 poseStack, boolean checkSides, class_5819 rand, long seed, int packedOverlay, ModelData modelData, class_1921 renderType) {
        ForgeModelBlockRenderer renderer = (ForgeModelBlockRenderer)class_310.method_1551().method_1541().method_3350();
        class_4587.class_4665 pose = poseStack.method_23760();
        boolean empty = true;
        boolean smoothLighter = lighter instanceof SmoothQuadLighter;
        QuadLighter flatLighter = null;
        rand.method_43052(seed);
        List quads = model.getQuads(state, null, rand, modelData, renderType);
        if (!quads.isEmpty()) {
            empty = false;
            lighter.setup(level, pos, state);
            for (class_777 quad : quads) {
                if (smoothLighter && !((BakedQuadInjection)quad).hasAmbientOcclusion()) {
                    if (flatLighter == null) {
                        flatLighter = renderer.flatLighter.get();
                        flatLighter.setup(level, pos, state);
                    }
                    flatLighter.process(vertexConsumer, pose, quad, packedOverlay);
                    continue;
                }
                lighter.process(vertexConsumer, pose, quad, packedOverlay);
            }
        }
        for (class_2350 side : SIDES) {
            if (checkSides && !class_2248.method_9607((class_2680)state, (class_1922)level, (class_2338)pos, (class_2350)side, (class_2338)pos.method_10093(side))) continue;
            rand.method_43052(seed);
            quads = model.getQuads(state, side, rand, modelData, renderType);
            if (quads.isEmpty()) continue;
            if (empty) {
                empty = false;
                lighter.setup(level, pos, state);
            }
            for (class_777 quad : quads) {
                if (smoothLighter && !((BakedQuadInjection)quad).hasAmbientOcclusion()) {
                    if (flatLighter == null) {
                        flatLighter = renderer.flatLighter.get();
                        flatLighter.setup(level, pos, state);
                    }
                    flatLighter.process(vertexConsumer, pose, quad, packedOverlay);
                    continue;
                }
                lighter.process(vertexConsumer, pose, quad, packedOverlay);
            }
        }
        lighter.reset();
        if (flatLighter != null) {
            flatLighter.reset();
        }
        return !empty;
    }
}

