/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.FileNotFoundException;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4013;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.obj.ObjMaterialLibrary;
import net.minecraftforge.client.model.obj.ObjModel;
import net.minecraftforge.client.model.obj.ObjTokenizer;

public class ObjLoader
implements IGeometryLoader<ObjModel>,
class_4013 {
    public static ObjLoader INSTANCE = new ObjLoader();
    private final Map<ObjModel.ModelSettings, ObjModel> modelCache = Maps.newConcurrentMap();
    private final Map<class_2960, ObjMaterialLibrary> materialCache = Maps.newConcurrentMap();
    private class_3300 manager = class_310.method_1551().method_1478();

    public void method_14491(class_3300 resourceManager) {
        this.modelCache.clear();
        this.materialCache.clear();
        this.manager = resourceManager;
    }

    @Override
    public ObjModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
        if (!jsonObject.has("model")) {
            throw new JsonParseException("OBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        String modelLocation = jsonObject.get("model").getAsString();
        boolean automaticCulling = class_3518.method_15258((JsonObject)jsonObject, (String)"automatic_culling", (boolean)true);
        boolean shadeQuads = class_3518.method_15258((JsonObject)jsonObject, (String)"shade_quads", (boolean)true);
        boolean flipV = class_3518.method_15258((JsonObject)jsonObject, (String)"flip_v", (boolean)false);
        boolean emissiveAmbient = class_3518.method_15258((JsonObject)jsonObject, (String)"emissive_ambient", (boolean)true);
        String mtlOverride = class_3518.method_15253((JsonObject)jsonObject, (String)"mtl_override", null);
        return this.loadModel(new ObjModel.ModelSettings(new class_2960(modelLocation), automaticCulling, shadeQuads, flipV, emissiveAmbient, mtlOverride));
    }

    public ObjModel loadModel(ObjModel.ModelSettings settings) {
        return this.modelCache.computeIfAbsent(settings, data -> {
            ObjModel objModel;
            class_3298 resource = (class_3298)this.manager.method_14486(settings.modelLocation()).orElseThrow();
            ObjTokenizer tokenizer = new ObjTokenizer(resource.method_14482());
            try {
                objModel = ObjModel.parse(tokenizer, settings);
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        tokenizer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ model", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ model", e);
                }
            }
            tokenizer.close();
            return objModel;
        });
    }

    public ObjMaterialLibrary loadMaterialLibrary(class_2960 materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            ObjMaterialLibrary objMaterialLibrary;
            class_3298 resource = (class_3298)this.manager.method_14486(location).orElseThrow();
            ObjTokenizer rdr = new ObjTokenizer(resource.method_14482());
            try {
                objMaterialLibrary = new ObjMaterialLibrary(rdr);
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        rdr.close();
                    }
                    catch (Throwable throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ material library", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ material library", e);
                }
            }
            rdr.close();
            return objMaterialLibrary;
        });
    }
}

