/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.renderable;

import java.util.Arrays;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3902;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraftforge.client.extensions.IForgeVertexConsumer;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.renderable.IRenderable;
import net.minecraftforge.client.model.renderable.ITextureRenderTypeLookup;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class BakedModelRenderable
implements IRenderable<Context> {
    private final class_1087 model;

    public static BakedModelRenderable of(class_2960 model) {
        return BakedModelRenderable.of(class_310.method_1551().method_1554().getModel(model));
    }

    public static BakedModelRenderable of(class_1087 model) {
        return new BakedModelRenderable(model);
    }

    private BakedModelRenderable(class_1087 model) {
        this.model = model;
    }

    @Override
    public void render(class_4587 poseStack, class_4597 bufferSource, ITextureRenderTypeLookup textureRenderTypeLookup, int lightmap, int overlay, float partialTick, Context context) {
        class_4588 buffer = bufferSource.getBuffer(textureRenderTypeLookup.get(class_1723.field_21668));
        Vector4f tint = context.tint();
        class_5819 randomSource = context.randomSource();
        for (class_2350 direction : context.faces()) {
            randomSource.method_43052(context.seed());
            for (class_777 quad : this.model.getQuads(context.state(), direction, randomSource, context.data(), null)) {
                ((IForgeVertexConsumer)buffer).putBulkData(poseStack.method_23760(), quad, tint.x(), tint.y(), tint.z(), tint.w(), lightmap, overlay, true);
            }
        }
    }

    @Override
    public IRenderable<class_3902> withContext(ModelData modelData) {
        return this.withContext(new Context(modelData));
    }

    public IRenderable<ModelData> withModelDataContext() {
        return (poseStack, bufferSource, textureRenderTypeLookup, lightmap, overlay, partialTick, context) -> this.render(poseStack, bufferSource, textureRenderTypeLookup, lightmap, overlay, partialTick, new Context((ModelData)context));
    }

    public record Context(@Nullable class_2680 state, class_2350[] faces, class_5819 randomSource, long seed, ModelData data, Vector4f tint) {
        private static final class_2350[] ALL_FACES_AND_NULL = Arrays.copyOf(class_2350.values(), class_2350.values().length + 1);
        private static final Vector4f WHITE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);

        public Context(ModelData data) {
            this(null, ALL_FACES_AND_NULL, class_5819.method_43047(), 42L, data, WHITE);
        }
    }
}

