/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraftforge.client.settings.KeyModifier;
import org.jetbrains.annotations.Nullable;

public class KeyMappingLookup {
    private static final EnumMap<KeyModifier, Map<class_3675.class_306, List<class_304>>> map = new EnumMap(KeyModifier.class);

    @Deprecated(forRemoval=true, since="1.20.1")
    @Nullable
    public class_304 get(class_3675.class_306 keyCode) {
        class_304 binding;
        KeyModifier activeModifier = KeyModifier.getActiveModifier();
        if (!activeModifier.matches(keyCode) && (binding = this.get(keyCode, activeModifier)) != null) {
            return binding;
        }
        return this.get(keyCode, KeyModifier.NONE);
    }

    @Deprecated(forRemoval=true, since="1.20.1")
    @Nullable
    private class_304 get(class_3675.class_306 keyCode, KeyModifier keyModifier) {
        List<class_304> bindings = map.get((Object)keyModifier).get(keyCode);
        if (bindings != null) {
            for (class_304 binding : bindings) {
                if (!binding.isActiveAndMatches(keyCode)) continue;
                return binding;
            }
        }
        return null;
    }

    public List<class_304> getAll(class_3675.class_306 keyCode) {
        ArrayList<class_304> ret = new ArrayList<class_304>();
        for (KeyModifier modifier : KeyModifier.getValues(false)) {
            if (!modifier.isActive(null) || modifier.matches(keyCode)) continue;
            for (class_304 binding : this.get(modifier, keyCode)) {
                if (!binding.isActiveAndMatches(keyCode)) continue;
                ret.add(binding);
            }
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        for (class_304 binding : this.get(KeyModifier.NONE, keyCode)) {
            if (!binding.isActiveAndMatches(keyCode)) continue;
            ret.add(binding);
        }
        return ret;
    }

    private List<class_304> get(KeyModifier modifier, class_3675.class_306 keyCode) {
        List<class_304> bindings = map.get((Object)modifier).get(keyCode);
        return bindings == null ? Collections.emptyList() : bindings;
    }

    public void put(class_3675.class_306 keyCode, class_304 keyBinding) {
        Map<class_3675.class_306, List<class_304>> bindingsMap = map.get((Object)keyBinding.getKeyModifier());
        List bindingsForKey = bindingsMap.computeIfAbsent(keyCode, k -> new ArrayList());
        bindingsForKey.add(keyBinding);
    }

    public void remove(class_304 keyBinding) {
        class_3675.class_306 keyCode = keyBinding.getKey();
        Map<class_3675.class_306, List<class_304>> bindingsMap = map.get((Object)keyBinding.getKeyModifier());
        List<class_304> bindingsForKey = bindingsMap.get(keyCode);
        if (bindingsForKey != null) {
            bindingsForKey.remove(keyBinding);
            if (bindingsForKey.isEmpty()) {
                bindingsMap.remove(keyCode);
            }
        }
    }

    public void clear() {
        map.values().forEach(Map::clear);
    }

    static {
        for (KeyModifier modifier : KeyModifier.values()) {
            map.put(modifier, new HashMap());
        }
    }
}

