/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.settings;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum KeyModifier {
    CONTROL{

        @Override
        public boolean matches(class_3675.class_306 key) {
            int keyCode = key.method_1444();
            if (class_310.field_1703) {
                return keyCode == 343 || keyCode == 347;
            }
            return keyCode == 341 || keyCode == 345;
        }

        @Override
        public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
            return class_437.method_25441();
        }

        @Override
        public class_2561 getCombinedName(class_3675.class_306 key, Supplier<class_2561> defaultLogic) {
            String localizationFormatKey = class_310.field_1703 ? "forge.controlsgui.control.mac" : "forge.controlsgui.control";
            return class_2561.method_43469((String)localizationFormatKey, (Object[])new Object[]{defaultLogic.get()});
        }
    }
    ,
    SHIFT{

        @Override
        public boolean matches(class_3675.class_306 key) {
            return key.method_1444() == 340 || key.method_1444() == 344;
        }

        @Override
        public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
            return class_437.method_25442();
        }

        @Override
        public class_2561 getCombinedName(class_3675.class_306 key, Supplier<class_2561> defaultLogic) {
            return class_2561.method_43469((String)"forge.controlsgui.shift", (Object[])new Object[]{defaultLogic.get()});
        }
    }
    ,
    ALT{

        @Override
        public boolean matches(class_3675.class_306 key) {
            return key.method_1444() == 342 || key.method_1444() == 346;
        }

        @Override
        public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
            return class_437.method_25443();
        }

        @Override
        public class_2561 getCombinedName(class_3675.class_306 keyCode, Supplier<class_2561> defaultLogic) {
            return class_2561.method_43469((String)"forge.controlsgui.alt", (Object[])new Object[]{defaultLogic.get()});
        }
    }
    ,
    NONE{

        @Override
        public boolean matches(class_3675.class_306 key) {
            return false;
        }

        @Override
        public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
            if (conflictContext != null && !conflictContext.conflicts(KeyConflictContext.IN_GAME)) {
                for (KeyModifier keyModifier : VALUES) {
                    if (!keyModifier.isActive(conflictContext)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public class_2561 getCombinedName(class_3675.class_306 key, Supplier<class_2561> defaultLogic) {
            return defaultLogic.get();
        }
    };

    @Deprecated(forRemoval=true, since="1.20.2")
    public static final KeyModifier[] MODIFIER_VALUES;
    private static final KeyModifier[] VALUES;
    private static final List<KeyModifier> VALUES_LIST;
    private static final List<KeyModifier> ALL;

    @Deprecated(forRemoval=true, since="1.20.2")
    public static KeyModifier getActiveModifier() {
        for (KeyModifier keyModifier : VALUES) {
            if (!keyModifier.isActive(null)) continue;
            return keyModifier;
        }
        return NONE;
    }

    public static final List<KeyModifier> getValues(boolean includeNone) {
        return includeNone ? ALL : VALUES_LIST;
    }

    @Nullable
    public static KeyModifier getModifier(class_3675.class_306 key) {
        for (KeyModifier modifier : VALUES) {
            if (!modifier.matches(key)) continue;
            return modifier;
        }
        return null;
    }

    public static boolean isKeyCodeModifier(class_3675.class_306 key) {
        for (KeyModifier keyModifier : VALUES) {
            if (!keyModifier.matches(key)) continue;
            return true;
        }
        return false;
    }

    public static KeyModifier valueFromString(String stringValue) {
        try {
            return KeyModifier.valueOf(stringValue);
        }
        catch (IllegalArgumentException | NullPointerException ignored) {
            return NONE;
        }
    }

    public abstract boolean matches(class_3675.class_306 var1);

    public abstract boolean isActive(@Nullable IKeyConflictContext var1);

    public abstract class_2561 getCombinedName(class_3675.class_306 var1, Supplier<class_2561> var2);

    static {
        MODIFIER_VALUES = new KeyModifier[]{SHIFT, CONTROL, ALT};
        VALUES = new KeyModifier[]{SHIFT, CONTROL, ALT};
        VALUES_LIST = List.of(SHIFT, CONTROL, ALT);
        ALL = List.of(SHIFT, CONTROL, ALT, NONE);
    }
}

