/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1761;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.CreativeModeTabSearchRegistry;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class CreativeModeTabRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 CREATIVE_MODE_TAB_ORDERING_JSON = new class_2960("forge", "creative_mode_tab_ordering.json");
    private static final List<class_1761> SORTED_TABS = new ArrayList<class_1761>();
    private static final List<class_1761> SORTED_TABS_VIEW = Collections.unmodifiableList(SORTED_TABS);
    private static final List<class_1761> DEFAULT_TABS = new ArrayList<class_1761>();
    private static final Multimap<class_2960, class_2960> edges = HashMultimap.create();

    public static List<class_1761> getSortedCreativeModeTabs() {
        return SORTED_TABS_VIEW;
    }

    public static List<class_1761> getDefaultTabs() {
        return Collections.unmodifiableList(DEFAULT_TABS);
    }

    @Nullable
    public static class_1761 getTab(class_2960 name) {
        return (class_1761)class_7923.field_44687.method_10223(name);
    }

    @Nullable
    public static class_2960 getName(class_1761 tab) {
        return class_7923.field_44687.method_10221((Object)tab);
    }

    static class_3302 getReloadListener() {
        return new class_4080<JsonObject>(){
            final Gson gson = new GsonBuilder().create();

            @NotNull
            protected JsonObject prepare(@NotNull class_3300 resourceManager, class_3695 profiler) {
                JsonObject jsonObject;
                block9: {
                    Optional res = resourceManager.method_14486(CREATIVE_MODE_TAB_ORDERING_JSON);
                    if (res.isEmpty()) {
                        return new JsonObject();
                    }
                    BufferedReader reader = ((class_3298)res.get()).method_43039();
                    try {
                        jsonObject = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
                        if (reader == null) break block9;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (reader != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                            }
                            throw throwable2;
                        }
                        catch (IOException e) {
                            LOGGER.error("Could not read CreativeModeTab sorting file " + String.valueOf(CREATIVE_MODE_TAB_ORDERING_JSON), (Throwable)e);
                            return new JsonObject();
                        }
                    }
                    ((Reader)reader).close();
                }
                return jsonObject;
            }

            protected void apply(@NotNull JsonObject data, @NotNull class_3300 resourceManager, class_3695 p) {
                try {
                    if (data.size() > 0) {
                        JsonArray order = class_3518.method_15261((JsonObject)data, (String)"order");
                        ArrayList<class_1761> customOrder = new ArrayList<class_1761>();
                        for (JsonElement entry : order) {
                            class_2960 id = new class_2960(entry.getAsString());
                            class_1761 CreativeModeTab2 = CreativeModeTabRegistry.getTab(id);
                            if (CreativeModeTab2 == null) {
                                throw new IllegalStateException("CreativeModeTab not found with name " + String.valueOf(id));
                            }
                            customOrder.add(CreativeModeTab2);
                        }
                        List<class_1761> missingCreativeModeTabs = class_7923.field_44687.method_10220().filter(CreativeModeTab -> !customOrder.contains(CreativeModeTab)).toList();
                        if (!missingCreativeModeTabs.isEmpty()) {
                            throw new IllegalStateException("CreativeModeTabs missing from the ordered list: " + missingCreativeModeTabs.stream().map(CreativeModeTab -> Objects.toString(CreativeModeTabRegistry.getName(CreativeModeTab))).collect(Collectors.joining(", ")));
                        }
                        CreativeModeTabRegistry.setCreativeModeTabOrder(customOrder);
                        return;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error parsing CreativeModeTab sorting file " + String.valueOf(CREATIVE_MODE_TAB_ORDERING_JSON), (Throwable)e);
                }
                CreativeModeTabRegistry.recalculateItemCreativeModeTabs();
            }
        };
    }

    private static void recalculateItemCreativeModeTabs() {
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
        for (class_1761 tab2 : class_7923.field_44687) {
            if (DEFAULT_TABS.contains(tab2)) continue;
            graph.addNode((Object)tab2);
        }
        edges.forEach((key, value) -> {
            class_1761 keyC = CreativeModeTabRegistry.getTab(key);
            class_1761 valueC = CreativeModeTabRegistry.getTab(value);
            if (keyC != null && valueC != null) {
                graph.putEdge((Object)keyC, (Object)valueC);
            }
        });
        List<class_1761> tierList = TopologicalSort.topologicalSort(graph, Comparator.comparing(tab -> CreativeModeTabRegistry.getName(tab)));
        CreativeModeTabRegistry.setCreativeModeTabOrder(tierList);
    }

    private static void setCreativeModeTabOrder(List<class_1761> tierList) {
        CreativeModeTabRegistry.runInServerThreadIfPossible(hasServer -> {
            SORTED_TABS.clear();
            SORTED_TABS.addAll(tierList);
        });
    }

    private static void runInServerThreadIfPossible(BooleanConsumer runnable) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.execute(() -> runnable.accept(true));
        } else {
            runnable.accept(false);
        }
    }

    @ApiStatus.Internal
    public static void sortTabs() {
        edges.clear();
        DEFAULT_TABS.add((class_1761)class_7923.field_44687.method_29107(class_7706.field_40199));
        DEFAULT_TABS.add((class_1761)class_7923.field_44687.method_29107(class_7706.field_40200));
        DEFAULT_TABS.add((class_1761)class_7923.field_44687.method_29107(class_7706.field_41063));
        DEFAULT_TABS.add((class_1761)class_7923.field_44687.method_29107(class_7706.field_40206));
        ArrayList indexed = new ArrayList();
        class_7923.field_44687.method_40270().filter(c -> !DEFAULT_TABS.contains(c.get())).forEach(indexed::add);
        int vanillaTabs = 10;
        for (int i = 0; i < vanillaTabs; ++i) {
            class_6880 value = (class_6880)indexed.get(i);
            class_1761 tab = (class_1761)value.get();
            class_2960 name = ((class_5321)value.method_40230().orElseThrow()).method_29177();
            if (!tab.kilt$getTabsBefore().isEmpty() || !tab.kilt$getTabsAfter().isEmpty()) {
                CreativeModeTabRegistry.addTabOrder(tab, name);
                continue;
            }
            if (i != 0) {
                edges.put((Object)((class_5321)((class_6880)indexed.get(i - 1)).method_40230().orElseThrow()).method_29177(), (Object)name);
            }
            if (i + 1 >= indexed.size()) continue;
            edges.put((Object)name, (Object)((class_5321)((class_6880)indexed.get(i + 1)).method_40230().orElseThrow()).method_29177());
        }
        class_2960 lastVanilla = ((class_5321)((class_6880)indexed.get(vanillaTabs - 1)).method_40230().orElseThrow()).method_29177();
        for (int i = vanillaTabs; i < indexed.size(); ++i) {
            class_6880 value = (class_6880)indexed.get(i);
            class_1761 tab = (class_1761)value.get();
            class_2960 name = ((class_5321)value.method_40230().orElseThrow()).method_29177();
            if (!tab.kilt$getTabsBefore().isEmpty() || !tab.kilt$getTabsAfter().isEmpty()) {
                CreativeModeTabRegistry.addTabOrder(tab, name);
                continue;
            }
            edges.put((Object)lastVanilla, (Object)name);
        }
        CreativeModeTabRegistry.recalculateItemCreativeModeTabs();
        if (FMLEnvironment.dist == Dist.CLIENT && !FMLLoader.getLaunchHandler().isData()) {
            CreativeModeTabSearchRegistry.createSearchTrees();
        }
    }

    private static void addTabOrder(class_1761 tab, class_2960 name) {
        for (class_2960 after : tab.kilt$getTabsAfter()) {
            edges.put((Object)name, (Object)after);
        }
        for (class_2960 before : tab.kilt$getTabsBefore()) {
            edges.put((Object)before, (Object)name);
        }
    }
}

