/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_6328;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public final class CapabilityDispatcher
implements INBTSerializable<class_2487>,
ICapabilityProvider {
    private final ICapabilityProvider[] caps;
    private final INBTSerializable<class_2520>[] writers;
    private final String[] names;
    private final List<Runnable> listeners;

    public CapabilityDispatcher(Map<class_2960, ICapabilityProvider> list, List<Runnable> listeners) {
        this(list, listeners, null);
    }

    public CapabilityDispatcher(Map<class_2960, ICapabilityProvider> list, List<Runnable> listeners, @Nullable ICapabilityProvider parent) {
        ArrayList<ICapabilityProvider> lstCaps = new ArrayList<ICapabilityProvider>();
        ArrayList<INBTSerializable> lstWriters = new ArrayList<INBTSerializable>();
        ArrayList<String> lstNames = new ArrayList<String>();
        this.listeners = listeners;
        if (parent != null) {
            lstCaps.add(parent);
            if (parent instanceof INBTSerializable) {
                lstWriters.add((INBTSerializable)((Object)parent));
                lstNames.add("Parent");
            }
        }
        for (Map.Entry<class_2960, ICapabilityProvider> entry : list.entrySet()) {
            ICapabilityProvider prov = entry.getValue();
            lstCaps.add(prov);
            if (!(prov instanceof INBTSerializable)) continue;
            lstWriters.add((INBTSerializable)((Object)prov));
            lstNames.add(entry.getKey().toString());
        }
        this.caps = lstCaps.toArray(new ICapabilityProvider[lstCaps.size()]);
        this.writers = lstWriters.toArray(new INBTSerializable[lstWriters.size()]);
        this.names = lstNames.toArray(new String[lstNames.size()]);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable class_2350 side) {
        for (ICapabilityProvider c : this.caps) {
            LazyOptional<T> ret = c.getCapability(cap, side);
            if (ret == null) {
                throw new RuntimeException(String.format(Locale.ENGLISH, "Provider %s.getCapability() returned null; return LazyOptional.empty() instead!", c.getClass().getTypeName()));
            }
            if (!ret.isPresent()) continue;
            return ret;
        }
        return LazyOptional.empty();
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = new class_2487();
        for (int x = 0; x < this.writers.length; ++x) {
            nbt.method_10566(this.names[x], this.writers[x].serializeNBT());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        for (int x = 0; x < this.writers.length; ++x) {
            if (!nbt.method_10545(this.names[x])) continue;
            this.writers[x].deserializeNBT(nbt.method_10580(this.names[x]));
        }
    }

    public boolean areCompatible(@Nullable CapabilityDispatcher other) {
        if (other == null) {
            return this.writers.length == 0;
        }
        if (this.writers.length == 0) {
            return other.writers.length == 0;
        }
        return this.serializeNBT().equals((Object)other.serializeNBT());
    }

    public void invalidate() {
        this.listeners.forEach(Runnable::run);
    }
}

