/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.kilt.injections.item.crafting.IngredientInjection;

public class CompoundIngredient
extends AbstractIngredient {
    private List<class_1856> children;
    private class_1799[] stacks;
    private IntList itemIds;
    private final boolean isSimple;

    protected CompoundIngredient(List<class_1856> children) {
        this.children = Collections.unmodifiableList(children);
        this.isSimple = children.stream().allMatch(IngredientInjection::isSimple);
    }

    public static class_1856 of(class_1856 ... children) {
        if (children.length == 0) {
            throw new IllegalArgumentException("Cannot create a compound ingredient with no children, use Ingredient.of() to create an empty ingredient");
        }
        if (children.length == 1) {
            return children[0];
        }
        ArrayList<class_1856> vanillaIngredients = new ArrayList<class_1856>();
        ArrayList<class_1856> allIngredients = new ArrayList<class_1856>();
        for (class_1856 child : children) {
            if (child.getSerializer() == VanillaIngredientSerializer.INSTANCE) {
                vanillaIngredients.add(child);
                continue;
            }
            allIngredients.add(child);
        }
        if (!vanillaIngredients.isEmpty()) {
            allIngredients.add(IngredientInjection.merge(vanillaIngredients));
        }
        if (allIngredients.size() == 1) {
            return (class_1856)allIngredients.get(0);
        }
        return new CompoundIngredient(allIngredients);
    }

    @NotNull
    public class_1799[] method_8105() {
        if (this.stacks == null) {
            ArrayList tmp = Lists.newArrayList();
            for (class_1856 child : this.children) {
                Collections.addAll(tmp, child.method_8105());
            }
            this.stacks = tmp.toArray(new class_1799[tmp.size()]);
        }
        return this.stacks;
    }

    @NotNull
    public IntList method_8100() {
        boolean childrenNeedInvalidation = false;
        for (class_1856 child : this.children) {
            childrenNeedInvalidation |= child.checkInvalidation();
        }
        if (childrenNeedInvalidation || this.itemIds == null || this.checkInvalidation()) {
            this.markValid();
            this.itemIds = new IntArrayList();
            for (class_1856 child : this.children) {
                this.itemIds.addAll(child.method_8100());
            }
            this.itemIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.itemIds;
    }

    public boolean method_8093(@Nullable class_1799 target) {
        if (target == null) {
            return false;
        }
        return this.children.stream().anyMatch(c -> c.method_8093(target));
    }

    public void invalidate() {
        this.itemIds = null;
        this.stacks = null;
    }

    @Override
    public boolean isSimple() {
        return this.isSimple;
    }

    @Override
    public IIngredientSerializer<? extends class_1856> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public Collection<class_1856> getChildren() {
        return this.children;
    }

    @Override
    public JsonElement method_8089() {
        if (this.children.size() == 1) {
            return this.children.get(0).method_8089();
        }
        JsonArray json = new JsonArray();
        this.children.stream().forEach(e -> json.add(e.method_8089()));
        return json;
    }

    public boolean method_8103() {
        return this.children.stream().allMatch(class_1856::method_8103);
    }

    public static class Serializer
    implements IIngredientSerializer<CompoundIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public CompoundIngredient parse(class_2540 buffer) {
            return new CompoundIngredient(Stream.generate(() -> class_1856.method_8086((class_2540)buffer)).limit(buffer.method_10816()).collect(Collectors.toList()));
        }

        @Override
        public CompoundIngredient parse(JsonObject json) {
            throw new JsonSyntaxException("CompoundIngredient should not be directly referenced in json, just use an array of ingredients.");
        }

        @Override
        public void write(class_2540 buffer, CompoundIngredient ingredient) {
            buffer.method_10804(ingredient.children.size());
            ingredient.children.forEach(c -> c.method_8088(buffer));
        }
    }
}

