/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class DifferenceIngredient
extends AbstractIngredient {
    private final class_1856 base;
    private final class_1856 subtracted;
    private class_1799[] filteredMatchingStacks;
    private IntList packedMatchingStacks;

    protected DifferenceIngredient(class_1856 base, class_1856 subtracted) {
        this.base = base;
        this.subtracted = subtracted;
    }

    public static DifferenceIngredient of(class_1856 base, class_1856 subtracted) {
        return new DifferenceIngredient(base, subtracted);
    }

    public boolean method_8093(@Nullable class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return this.base.method_8093(stack) && !this.subtracted.method_8093(stack);
    }

    public class_1799[] method_8105() {
        if (this.filteredMatchingStacks == null) {
            this.filteredMatchingStacks = (class_1799[])Arrays.stream(this.base.method_8105()).filter(stack -> !this.subtracted.method_8093(stack)).toArray(class_1799[]::new);
        }
        return this.filteredMatchingStacks;
    }

    public boolean method_8103() {
        return this.base.method_8103();
    }

    @Override
    public boolean isSimple() {
        return this.base.isSimple() && this.subtracted.isSimple();
    }

    public void invalidate() {
        super.invalidate();
        this.filteredMatchingStacks = null;
        this.packedMatchingStacks = null;
    }

    public IntList method_8100() {
        if (this.packedMatchingStacks == null || this.checkInvalidation()) {
            this.markValid();
            class_1799[] matchingStacks = this.method_8105();
            this.packedMatchingStacks = new IntArrayList(matchingStacks.length);
            for (class_1799 stack : matchingStacks) {
                this.packedMatchingStacks.add(class_1662.method_7408((class_1799)stack));
            }
            this.packedMatchingStacks.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.packedMatchingStacks;
    }

    @Override
    public JsonElement method_8089() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID(Serializer.INSTANCE).toString());
        json.add("base", this.base.method_8089());
        json.add("subtracted", this.subtracted.method_8089());
        return json;
    }

    public IIngredientSerializer<DifferenceIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<DifferenceIngredient> {
        public static final IIngredientSerializer<DifferenceIngredient> INSTANCE = new Serializer();

        @Override
        public DifferenceIngredient parse(JsonObject json) {
            class_1856 base = class_1856.method_8102((JsonElement)json.get("base"), (boolean)false);
            class_1856 without = class_1856.method_8102((JsonElement)json.get("subtracted"), (boolean)false);
            return new DifferenceIngredient(base, without);
        }

        @Override
        public DifferenceIngredient parse(class_2540 buffer) {
            class_1856 base = class_1856.method_8086((class_2540)buffer);
            class_1856 without = class_1856.method_8086((class_2540)buffer);
            return new DifferenceIngredient(base, without);
        }

        @Override
        public void write(class_2540 buffer, DifferenceIngredient ingredient) {
            ingredient.base.method_8088(buffer);
            ingredient.subtracted.method_8088(buffer);
        }
    }
}

