/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.kilt.injections.item.crafting.IngredientInjection;

public class IntersectionIngredient
extends AbstractIngredient {
    private final List<class_1856> children;
    private final boolean isSimple;
    private class_1799[] intersectedMatchingStacks = null;
    private IntList packedMatchingStacks = null;

    protected IntersectionIngredient(List<class_1856> children) {
        if (children.size() < 2) {
            throw new IllegalArgumentException("Cannot create an IntersectionIngredient with one or no children");
        }
        this.children = Collections.unmodifiableList(children);
        this.isSimple = children.stream().allMatch(IngredientInjection::isSimple);
    }

    public static class_1856 of(class_1856 ... ingredients) {
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Cannot create an IntersectionIngredient with no children, use Ingredient.of() to create an empty ingredient");
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        return new IntersectionIngredient(Arrays.asList(ingredients));
    }

    public boolean method_8093(@Nullable class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        for (class_1856 ingredient : this.children) {
            if (ingredient.method_8093(stack)) continue;
            return false;
        }
        return true;
    }

    public class_1799[] method_8105() {
        if (this.intersectedMatchingStacks == null) {
            this.intersectedMatchingStacks = (class_1799[])Arrays.stream(this.children.get(0).method_8105()).filter(stack -> {
                for (int i = 1; i < this.children.size(); ++i) {
                    if (this.children.get(i).method_8093(stack)) continue;
                    return false;
                }
                return true;
            }).toArray(class_1799[]::new);
        }
        return this.intersectedMatchingStacks;
    }

    public boolean method_8103() {
        return this.children.stream().anyMatch(class_1856::method_8103);
    }

    @Override
    public boolean isSimple() {
        return this.isSimple;
    }

    public void invalidate() {
        super.invalidate();
        this.intersectedMatchingStacks = null;
        this.packedMatchingStacks = null;
    }

    public IntList method_8100() {
        if (this.packedMatchingStacks == null || this.checkInvalidation()) {
            this.markValid();
            class_1799[] matchingStacks = this.method_8105();
            this.packedMatchingStacks = new IntArrayList(matchingStacks.length);
            for (class_1799 stack : matchingStacks) {
                this.packedMatchingStacks.add(class_1662.method_7408((class_1799)stack));
            }
            this.packedMatchingStacks.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.packedMatchingStacks;
    }

    @Override
    public JsonElement method_8089() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID(Serializer.INSTANCE).toString());
        JsonArray array = new JsonArray();
        for (class_1856 ingredient : this.children) {
            array.add(ingredient.method_8089());
        }
        json.add("children", (JsonElement)array);
        return json;
    }

    public IIngredientSerializer<IntersectionIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<IntersectionIngredient> {
        public static final IIngredientSerializer<IntersectionIngredient> INSTANCE = new Serializer();

        @Override
        public IntersectionIngredient parse(JsonObject json) {
            JsonArray children = class_3518.method_15261((JsonObject)json, (String)"children");
            if (children.size() < 2) {
                throw new JsonSyntaxException("Must have at least two children for an intersection ingredient");
            }
            return new IntersectionIngredient(IntStream.range(0, children.size()).mapToObj(i -> class_1856.method_8102((JsonElement)children.get(i), (boolean)false)).toList());
        }

        @Override
        public IntersectionIngredient parse(class_2540 buffer) {
            return new IntersectionIngredient(Stream.generate(() -> class_1856.method_8086((class_2540)buffer)).limit(buffer.method_10816()).toList());
        }

        @Override
        public void write(class_2540 buffer, IntersectionIngredient intersection) {
            buffer.method_10804(intersection.children.size());
            for (class_1856 ingredient : intersection.children) {
                ingredient.method_8088(buffer);
            }
        }
    }
}

