/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.conditions;

import com.google.gson.JsonObject;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemExistsCondition
implements ICondition {
    private static final class_2960 NAME = new class_2960("forge", "item_exists");
    private final class_2960 item;

    public ItemExistsCondition(String location) {
        this(new class_2960(location));
    }

    public ItemExistsCondition(String namespace, String path) {
        this(new class_2960(namespace, path));
    }

    public ItemExistsCondition(class_2960 item) {
        this.item = item;
    }

    @Override
    public class_2960 getID() {
        return NAME;
    }

    @Override
    public boolean test(ICondition.IContext context) {
        return ForgeRegistries.ITEMS.containsKey(this.item);
    }

    public String toString() {
        return "item_exists(\"" + String.valueOf(this.item) + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<ItemExistsCondition> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void write(JsonObject json, ItemExistsCondition value) {
            json.addProperty("item", value.item.toString());
        }

        @Override
        public ItemExistsCondition read(JsonObject json) {
            return new ItemExistsCondition(new class_2960(class_3518.method_15265((JsonObject)json, (String)"item")));
        }

        @Override
        public class_2960 getID() {
            return NAME;
        }
    }
}

