/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1064;
import net.minecraft.class_1065;
import net.minecraft.class_2960;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3286;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6861;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.resource.ResourcePackLoader;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ExistingFileHelper {
    private final class_6861 clientResources;
    private final class_6861 serverData;
    private final boolean enable;
    private final Multimap<class_3264, class_2960> generated = HashMultimap.create();

    public ExistingFileHelper(Collection<Path> existingPacks, Set<String> existingMods, boolean enable, @Nullable String assetIndex, @Nullable File assetsDir) {
        Object pack;
        ArrayList<Object> candidateClientResources = new ArrayList<Object>();
        ArrayList<Object> candidateServerResources = new ArrayList<Object>();
        if (assetIndex != null && assetsDir != null && assetsDir.exists()) {
            candidateClientResources.add(class_1065.method_45857((Path)class_1064.method_45858((Path)assetsDir.toPath(), (String)assetIndex)));
        }
        candidateServerResources.add(class_3286.method_45287());
        for (Path existing : existingPacks) {
            File file = existing.toFile();
            pack = file.isDirectory() ? new class_3259(file.getName(), file.toPath(), false) : new class_3258(file.getName(), file, false);
            candidateClientResources.add(pack);
            candidateServerResources.add(pack);
        }
        for (String existingMod : existingMods) {
            IModFileInfo modFileInfo = ModList.get().getModFileById(existingMod);
            if (modFileInfo == null) continue;
            pack = ResourcePackLoader.createPackForMod(modFileInfo);
            candidateClientResources.add(pack);
            candidateServerResources.add(pack);
        }
        this.clientResources = new class_6861(class_3264.field_14188, candidateClientResources);
        this.serverData = new class_6861(class_3264.field_14190, candidateServerResources);
        this.enable = enable;
    }

    private class_3300 getManager(class_3264 packType) {
        return packType == class_3264.field_14188 ? this.clientResources : this.serverData;
    }

    private class_2960 getLocation(class_2960 base, String suffix, String prefix) {
        return new class_2960(base.method_12836(), prefix + "/" + base.method_12832() + suffix);
    }

    public boolean exists(class_2960 loc, class_3264 packType) {
        if (!this.enable) {
            return true;
        }
        return this.generated.get((Object)packType).contains(loc) || this.getManager(packType).method_14486(loc).isPresent();
    }

    public boolean exists(class_2960 loc, IResourceType type) {
        return this.exists(this.getLocation(loc, type.getSuffix(), type.getPrefix()), type.getPackType());
    }

    public boolean exists(class_2960 loc, class_3264 packType, String pathSuffix, String pathPrefix) {
        return this.exists(this.getLocation(loc, pathSuffix, pathPrefix), packType);
    }

    public void trackGenerated(class_2960 loc, IResourceType type) {
        this.generated.put((Object)type.getPackType(), (Object)this.getLocation(loc, type.getSuffix(), type.getPrefix()));
    }

    public void trackGenerated(class_2960 loc, class_3264 packType, String pathSuffix, String pathPrefix) {
        this.generated.put((Object)packType, (Object)this.getLocation(loc, pathSuffix, pathPrefix));
    }

    @VisibleForTesting
    public class_3298 getResource(class_2960 loc, class_3264 packType, String pathSuffix, String pathPrefix) throws FileNotFoundException {
        return this.getResource(this.getLocation(loc, pathSuffix, pathPrefix), packType);
    }

    @VisibleForTesting
    public class_3298 getResource(class_2960 loc, class_3264 packType) throws FileNotFoundException {
        return this.getManager(packType).getResourceOrThrow(loc);
    }

    @VisibleForTesting
    public List<class_3298> getResourceStack(class_2960 loc, class_3264 packType) {
        return this.getManager(packType).method_14489(loc);
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public static interface IResourceType {
        public class_3264 getPackType();

        public String getSuffix();

        public String getPrefix();
    }

    public static class ResourceType
    implements IResourceType {
        final class_3264 packType;
        final String suffix;
        final String prefix;

        public ResourceType(class_3264 type, String suffix, String prefix) {
            this.packType = type;
            this.suffix = suffix;
            this.prefix = prefix;
        }

        @Override
        public class_3264 getPackType() {
            return this.packType;
        }

        @Override
        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }
    }
}

