/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_2396;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class ParticleDescriptionProvider
implements class_2405 {
    private final class_7784.class_7489 particlesPath;
    @VisibleForTesting
    protected final ExistingFileHelper fileHelper;
    @VisibleForTesting
    protected final Map<class_2960, List<String>> descriptions;

    protected ParticleDescriptionProvider(class_7784 output, ExistingFileHelper fileHelper) {
        this.particlesPath = output.method_45973(class_7784.class_7490.field_39368, "particles");
        this.fileHelper = fileHelper;
        this.descriptions = new HashMap<class_2960, List<String>>();
    }

    protected abstract void addDescriptions();

    protected void sprite(class_2396<?> type, class_2960 texture) {
        this.spriteSet(type, texture, new class_2960[0]);
    }

    protected void spriteSet(class_2396<?> type, final class_2960 baseName, final int numOfTextures, final boolean reverse) {
        Preconditions.checkArgument((numOfTextures > 0 ? 1 : 0) != 0, (Object)"The number of textures to generate must be positive");
        this.spriteSet(type, () -> new Iterator<class_2960>(){
            private int counter = 0;

            @Override
            public boolean hasNext() {
                return this.counter < numOfTextures;
            }

            @Override
            public class_2960 next() {
                class_2960 texture = baseName.method_48331("_" + (reverse ? numOfTextures - this.counter - 1 : this.counter));
                ++this.counter;
                return texture;
            }
        });
    }

    protected void spriteSet(class_2396<?> type, class_2960 texture, class_2960 ... textures) {
        this.spriteSet(type, Stream.concat(Stream.of(texture), Arrays.stream(textures))::iterator);
    }

    protected void spriteSet(class_2396<?> type, Iterable<class_2960> textures) {
        class_2960 particle = (class_2960)Preconditions.checkNotNull((Object)ForgeRegistries.PARTICLE_TYPES.getKey(type), (Object)"The particle type is not registered");
        ArrayList<String> desc = new ArrayList<String>();
        for (class_2960 texture : textures) {
            Preconditions.checkArgument((boolean)this.fileHelper.exists(texture, class_3264.field_14188, ".png", "textures/particle"), (String)"Texture '%s' does not exist in any known resource pack", (Object)texture);
            desc.add(texture.toString());
        }
        Preconditions.checkArgument((desc.size() > 0 ? 1 : 0) != 0, (String)"The particle type '%s' must have one texture", (Object)particle);
        if (this.descriptions.putIfAbsent(particle, desc) != null) {
            throw new IllegalArgumentException(String.format("The particle type '%s' already has a description associated with it", particle));
        }
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.addDescriptions();
        return CompletableFuture.allOf((CompletableFuture[])this.descriptions.entrySet().stream().map(entry -> {
            JsonArray textures = new JsonArray();
            ((List)entry.getValue()).forEach(arg_0 -> ((JsonArray)textures).add(arg_0));
            return class_2405.method_10320((class_7403)cache, (JsonElement)((JsonElement)class_156.method_654((Object)new JsonObject(), obj -> obj.add("textures", (JsonElement)textures))), (Path)this.particlesPath.method_44107((class_2960)entry.getKey()));
        }).toArray(CompletableFuture[]::new));
    }

    public String method_10321() {
        return "Particle Descriptions";
    }
}

