/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.NotNull;

public interface IForgeFriendlyByteBuf {
    private class_2540 self() {
        return (class_2540)this;
    }

    default public <T> void writeRegistryIdUnsafe(@NotNull IForgeRegistry<T> registry, @NotNull T entry) {
        ForgeRegistry forgeRegistry = (ForgeRegistry)registry;
        int id = forgeRegistry.getID(entry);
        this.self().method_10804(id);
    }

    default public void writeRegistryIdUnsafe(@NotNull IForgeRegistry<?> registry, @NotNull class_2960 entryKey) {
        ForgeRegistry forgeRegistry = (ForgeRegistry)registry;
        int id = forgeRegistry.getID(entryKey);
        this.self().method_10804(id);
    }

    default public <T> T readRegistryIdUnsafe(@NotNull IForgeRegistry<T> registry) {
        ForgeRegistry forgeRegistry = (ForgeRegistry)registry;
        int id = this.self().method_10816();
        return (T)forgeRegistry.getValue(id);
    }

    default public <T> void writeRegistryId(@NotNull IForgeRegistry<T> registry, @NotNull T entry) {
        Objects.requireNonNull(registry, "Cannot write a null registry key!");
        Objects.requireNonNull(entry, "Cannot write a null registry entry!");
        class_2960 name = registry.getRegistryName();
        Preconditions.checkArgument((boolean)registry.containsValue(entry), (String)"Cannot find %s in %s", registry.getKey(entry) != null ? registry.getKey(entry) : entry, (Object)name);
        ForgeRegistry reg = (ForgeRegistry)registry;
        this.self().method_10812(name);
        this.self().method_10804(reg.getID(entry));
    }

    default public <T> T readRegistryId() {
        class_2960 location = this.self().method_10810();
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(location);
        return (T)registry.getValue(this.self().method_10816());
    }

    default public <T> T readRegistryIdSafe(Class<? super T> registrySuperType) {
        T value = this.readRegistryId();
        if (!registrySuperType.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Attempted to read an registryValue of the wrong type from the Buffer!");
        }
        return value;
    }

    default public void writeFluidStack(FluidStack stack) {
        if (stack.isEmpty()) {
            this.self().writeBoolean(false);
        } else {
            this.self().writeBoolean(true);
            stack.forge$writeToPacket(this.self());
        }
    }

    default public FluidStack readFluidStack() {
        return !this.self().readBoolean() ? FluidStack.EMPTY : FluidStack.readFromPacket(this.self());
    }
}

