/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5270;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootModifierManager
extends class_4309 {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Gson GSON_INSTANCE = class_5270.method_27861().create();
    private Map<class_2960, IGlobalLootModifier> registeredLootModifiers = ImmutableMap.of();
    private static final String folder = "loot_modifiers";

    public LootModifierManager() {
        super(GSON_INSTANCE, folder);
    }

    protected void apply(Map<class_2960, JsonElement> resourceList, class_3300 resourceManagerIn, class_3695 profilerIn) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ArrayList<class_2960> finalLocations = new ArrayList<class_2960>();
        class_2960 resourcelocation = new class_2960("forge", "loot_modifiers/global_loot_modifiers.json");
        for (class_3298 iresource : resourceManagerIn.method_14489(resourcelocation)) {
            try {
                InputStream inputstream = iresource.method_14482();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    JsonObject jsonobject = (JsonObject)class_3518.method_15276((Gson)GSON_INSTANCE, (Reader)reader, JsonObject.class);
                    boolean replace = jsonobject.get("replace").getAsBoolean();
                    if (replace) {
                        finalLocations.clear();
                    }
                    JsonArray entryList = jsonobject.get("entries").getAsJsonArray();
                    for (JsonElement entry : entryList) {
                        class_2960 loc = new class_2960(entry.getAsString());
                        finalLocations.remove(loc);
                        finalLocations.add(loc);
                    }
                }
                finally {
                    if (inputstream == null) continue;
                    inputstream.close();
                }
            }
            catch (IOException | RuntimeException ioexception) {
                LOGGER.error("Couldn't read global loot modifier list {} in data pack {}", (Object)resourcelocation, (Object)iresource.method_14480(), (Object)ioexception);
            }
        }
        for (class_2960 location : finalLocations) {
            JsonElement json = resourceList.get(location);
            IGlobalLootModifier.DIRECT_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(errorMsg -> LOGGER.warn("Could not decode GlobalLootModifier with json id {} - error: {}", (Object)location, errorMsg)).ifPresent(modifier -> builder.put((Object)location, modifier));
        }
        this.registeredLootModifiers = builder.build();
    }

    public Collection<IGlobalLootModifier> getAllLootMods() {
        return this.registeredLootModifiers.values();
    }
}

