/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.world;

import com.mojang.serialization.Codec;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_5483;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;

public final class ForgeBiomeModifiers {
    private ForgeBiomeModifiers() {
    }

    public record RemoveSpawnsBiomeModifier(class_6885<class_1959> biomes, class_6885<class_1299<?>> entityTypes) implements BiomeModifier
    {
        @Override
        public void modify(class_6880<class_1959> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.REMOVE && this.biomes.method_40241(biome)) {
                MobSpawnSettingsBuilder spawnBuilder = builder.getMobSpawnSettings();
                for (class_1311 category : class_1311.values()) {
                    List<class_5483.class_1964> spawns = spawnBuilder.getSpawner(category);
                    spawns.removeIf(spawnerData -> this.entityTypes.method_40241(ForgeRegistries.ENTITY_TYPES.getHolder(spawnerData.field_9389).get()));
                }
            }
        }

        @Override
        public Codec<? extends BiomeModifier> codec() {
            return ForgeMod.REMOVE_SPAWNS_BIOME_MODIFIER_TYPE.get();
        }
    }

    public record AddSpawnsBiomeModifier(class_6885<class_1959> biomes, List<class_5483.class_1964> spawners) implements BiomeModifier
    {
        public static AddSpawnsBiomeModifier singleSpawn(class_6885<class_1959> biomes, class_5483.class_1964 spawner) {
            return new AddSpawnsBiomeModifier(biomes, List.of(spawner));
        }

        @Override
        public void modify(class_6880<class_1959> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.method_40241(biome)) {
                MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
                for (class_5483.class_1964 spawner : this.spawners) {
                    class_1299 type = spawner.field_9389;
                    spawns.method_31011(type.method_5891(), spawner);
                }
            }
        }

        @Override
        public Codec<? extends BiomeModifier> codec() {
            return ForgeMod.ADD_SPAWNS_BIOME_MODIFIER_TYPE.get();
        }
    }

    public record RemoveFeaturesBiomeModifier(class_6885<class_1959> biomes, class_6885<class_6796> features, Set<class_2893.class_2895> steps) implements BiomeModifier
    {
        public static RemoveFeaturesBiomeModifier allSteps(class_6885<class_1959> biomes, class_6885<class_6796> features) {
            return new RemoveFeaturesBiomeModifier(biomes, features, EnumSet.allOf(class_2893.class_2895.class));
        }

        @Override
        public void modify(class_6880<class_1959> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.REMOVE && this.biomes.method_40241(biome)) {
                BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
                for (class_2893.class_2895 step : this.steps) {
                    generationSettings.getFeatures(step).removeIf(arg_0 -> this.features.method_40241(arg_0));
                }
            }
        }

        @Override
        public Codec<? extends BiomeModifier> codec() {
            return ForgeMod.REMOVE_FEATURES_BIOME_MODIFIER_TYPE.get();
        }
    }

    public record AddFeaturesBiomeModifier(class_6885<class_1959> biomes, class_6885<class_6796> features, class_2893.class_2895 step) implements BiomeModifier
    {
        @Override
        public void modify(class_6880<class_1959> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.method_40241(biome)) {
                BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
                this.features.forEach(holder -> generationSettings.method_46676(this.step, (class_6880)holder));
            }
        }

        @Override
        public Codec<? extends BiomeModifier> codec() {
            return ForgeMod.ADD_FEATURES_BIOME_MODIFIER_TYPE.get();
        }
    }
}

