/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.world;

import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.chunk.loading.PortingLibChunkManager;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1297;
import net.minecraft.class_1932;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.bluspring.kilt.mixin.compat.porting_lib.TicketHelperAccessor;
import xyz.bluspring.kilt.mixin.compat.porting_lib.TicketOwnerAccessor;
import xyz.bluspring.kilt.mixin.compat.porting_lib.TicketTrackerAccessor;

@ParametersAreNonnullByDefault
public class ForgeChunkManager {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void setForcedChunkLoadingCallback(String modId, LoadingValidationCallback callback) {
        PortingLibChunkManager.setForcedChunkLoadingCallback((String)modId, (level, ticketHelper) -> callback.validateTickets(level, TicketHelper.fromFabric(ticketHelper)));
    }

    public static boolean hasForcedChunks(class_3218 level) {
        return PortingLibChunkManager.hasForcedChunks((class_3218)level);
    }

    public static boolean forceChunk(class_3218 level, String modId, class_2338 owner, int chunkX, int chunkZ, boolean add, boolean ticking) {
        return PortingLibChunkManager.forceChunk((class_3218)level, (String)modId, (class_2338)owner, (int)chunkX, (int)chunkZ, (boolean)add, (boolean)ticking);
    }

    public static boolean forceChunk(class_3218 level, String modId, class_1297 owner, int chunkX, int chunkZ, boolean add, boolean ticking) {
        return PortingLibChunkManager.forceChunk((class_3218)level, (String)modId, (UUID)owner.method_5667(), (int)chunkX, (int)chunkZ, (boolean)add, (boolean)ticking);
    }

    public static boolean forceChunk(class_3218 level, String modId, UUID owner, int chunkX, int chunkZ, boolean add, boolean ticking) {
        return PortingLibChunkManager.forceChunk((class_3218)level, (String)modId, (UUID)owner, (int)chunkX, (int)chunkZ, (boolean)add, (boolean)ticking);
    }

    public static void reinstatePersistentChunks(class_3218 level, class_1932 saveData) {
        PortingLibChunkManager.reinstatePersistentChunks((class_3218)level, (class_1932)saveData);
    }

    public static void writeForgeForcedChunks(class_2487 nbt, TicketTracker<class_2338> blockForcedChunks, TicketTracker<UUID> entityForcedChunks) {
        PortingLibChunkManager.writeForgeForcedChunks((class_2487)nbt, blockForcedChunks.toFabric(), entityForcedChunks.toFabric());
    }

    public static void readForgeForcedChunks(class_2487 nbt, TicketTracker<class_2338> blockForcedChunks, TicketTracker<UUID> entityForcedChunks) {
        PortingLibChunkManager.readForgeForcedChunks((class_2487)nbt, blockForcedChunks.toFabric(), entityForcedChunks.toFabric());
    }

    @FunctionalInterface
    public static interface LoadingValidationCallback {
        public void validateTickets(class_3218 var1, TicketHelper var2);
    }

    public static class TicketTracker<T extends Comparable<? super T>> {
        private final Map<TicketOwner<T>, LongSet> chunks = new HashMap<TicketOwner<T>, LongSet>();
        private final Map<TicketOwner<T>, LongSet> tickingChunks = new HashMap<TicketOwner<T>, LongSet>();

        public PortingLibChunkManager.TicketTracker<T> toFabric() {
            PortingLibChunkManager.TicketTracker tracker = new PortingLibChunkManager.TicketTracker();
            TicketTrackerAccessor accessor = (TicketTrackerAccessor)tracker;
            this.chunks.forEach((owner, set) -> accessor.kilt$getChunks().put(owner.toFabric(), (LongSet)set));
            this.tickingChunks.forEach((owner, set) -> accessor.kilt$getTickingChunks().put(owner.toFabric(), (LongSet)set));
            return tracker;
        }

        public Map<TicketOwner<T>, LongSet> getChunks() {
            return Collections.unmodifiableMap(this.chunks);
        }

        public Map<TicketOwner<T>, LongSet> getTickingChunks() {
            return Collections.unmodifiableMap(this.tickingChunks);
        }

        public boolean isEmpty() {
            return this.chunks.isEmpty() && this.tickingChunks.isEmpty();
        }

        private Map<TicketOwner<T>, LongSet> getTickets(boolean ticking) {
            return ticking ? this.tickingChunks : this.chunks;
        }

        private boolean remove(TicketOwner<T> owner, long chunk, boolean ticking) {
            LongSet ticketChunks;
            Map<TicketOwner<T>, LongSet> tickets = this.getTickets(ticking);
            if (tickets.containsKey(owner) && (ticketChunks = tickets.get(owner)).remove(chunk)) {
                if (ticketChunks.isEmpty()) {
                    tickets.remove(owner);
                }
                return true;
            }
            return false;
        }

        private boolean add(TicketOwner<T> owner, long chunk, boolean ticking) {
            return this.getTickets(ticking).computeIfAbsent(owner, o -> new LongOpenHashSet()).add(chunk);
        }
    }

    public static class TicketHelper {
        private final Map<class_2338, Pair<LongSet, LongSet>> blockTickets;
        private final Map<UUID, Pair<LongSet, LongSet>> entityTickets;
        private final class_1932 saveData;
        private final String modId;

        public static TicketHelper fromFabric(PortingLibChunkManager.TicketHelper fabric) {
            TicketHelperAccessor accessor = (TicketHelperAccessor)fabric;
            return new TicketHelper(accessor.getSaveData(), accessor.getModId(), accessor.getBlockTickets(), accessor.getEntityTickets());
        }

        private TicketHelper(class_1932 saveData, String modId, Map<class_2338, Pair<LongSet, LongSet>> blockTickets, Map<UUID, Pair<LongSet, LongSet>> entityTickets) {
            this.saveData = saveData;
            this.modId = modId;
            this.blockTickets = blockTickets;
            this.entityTickets = entityTickets;
        }

        public Map<class_2338, Pair<LongSet, LongSet>> getBlockTickets() {
            return this.blockTickets;
        }

        public Map<UUID, Pair<LongSet, LongSet>> getEntityTickets() {
            return this.entityTickets;
        }

        public void removeAllTickets(class_2338 owner) {
            this.removeAllTickets(this.saveData.getBlockForcedChunks(), owner);
        }

        public void removeAllTickets(UUID owner) {
            this.removeAllTickets(this.saveData.getEntityForcedChunks(), owner);
        }

        private <T extends Comparable<? super T>> void removeAllTickets(PortingLibChunkManager.TicketTracker<T> tickets, T owner) {
            TicketOwner<T> ticketOwner = new TicketOwner<T>(this.modId, owner);
            if (tickets.getChunks().containsKey(ticketOwner) || tickets.getTickingChunks().containsKey(ticketOwner)) {
                ((TicketTrackerAccessor)tickets).kilt$getChunks().remove(ticketOwner);
                ((TicketTrackerAccessor)tickets).kilt$getTickingChunks().remove(ticketOwner);
                this.saveData.method_78(true);
            }
        }

        public void removeTicket(class_2338 owner, long chunk, boolean ticking) {
            this.removeTicket(this.saveData.getBlockForcedChunks(), owner, chunk, ticking);
        }

        public void removeTicket(UUID owner, long chunk, boolean ticking) {
            this.removeTicket(this.saveData.getEntityForcedChunks(), owner, chunk, ticking);
        }

        private <T extends Comparable<? super T>> void removeTicket(PortingLibChunkManager.TicketTracker<T> tickets, T owner, long chunk, boolean ticking) {
            if (((TicketTrackerAccessor)tickets).callRemove(new TicketOwner<T>(this.modId, owner).toFabric(), chunk, ticking)) {
                this.saveData.method_78(true);
            }
        }
    }

    public static class TicketOwner<T extends Comparable<? super T>>
    implements Comparable<TicketOwner<T>> {
        private final String modId;
        private final T owner;

        private TicketOwner(String modId, T owner) {
            this.modId = modId;
            this.owner = owner;
        }

        public PortingLibChunkManager.TicketOwner<T> toFabric() {
            return TicketOwnerAccessor.createTicketOwner(this.modId, this.owner);
        }

        @Override
        public int compareTo(TicketOwner<T> other) {
            int res = this.modId.compareTo(other.modId);
            return res == 0 ? this.owner.compareTo(other.owner) : res;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TicketOwner that = (TicketOwner)o;
            return Objects.equals(this.modId, that.modId) && Objects.equals(this.owner, that.owner);
        }

        public int hashCode() {
            return Objects.hash(this.modId, this.owner);
        }
    }
}

