/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_3195;
import net.minecraft.class_5483;
import net.minecraft.class_5847;
import net.minecraft.class_6012;
import net.minecraft.class_6885;
import net.minecraft.class_7061;
import org.jetbrains.annotations.Nullable;

public class StructureSettingsBuilder {
    private class_6885<class_1959> biomes;
    private final Map<class_1311, StructureSpawnOverrideBuilder> spawnOverrides;
    private class_2893.class_2895 step;
    private class_5847 terrainAdaptation;

    public static StructureSettingsBuilder copyOf(class_3195.class_7302 settings) {
        return new StructureSettingsBuilder((class_6885<class_1959>)settings.comp_686(), settings.comp_687(), settings.comp_688(), settings.comp_689());
    }

    private StructureSettingsBuilder(class_6885<class_1959> biomes, Map<class_1311, class_7061> spawnOverrides, class_2893.class_2895 step, class_5847 terrainAdaptation) {
        this.biomes = biomes;
        this.spawnOverrides = spawnOverrides.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> StructureSpawnOverrideBuilder.copyOf((class_7061)entry.getValue())));
        this.step = step;
        this.terrainAdaptation = terrainAdaptation;
    }

    public class_3195.class_7302 build() {
        Map<class_1311, class_7061> overrides = Collections.unmodifiableMap(this.spawnOverrides.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StructureSpawnOverrideBuilder)entry.getValue()).build())));
        return new class_3195.class_7302(this.biomes, overrides, this.step, this.terrainAdaptation);
    }

    public class_6885<class_1959> getBiomes() {
        return this.biomes;
    }

    public void setBiomes(class_6885<class_1959> biomes) {
        this.biomes = biomes;
    }

    @Nullable
    public StructureSpawnOverrideBuilder getSpawnOverrides(class_1311 category) {
        return this.spawnOverrides.get(category);
    }

    public StructureSpawnOverrideBuilder getOrAddSpawnOverrides(class_1311 category) {
        return this.spawnOverrides.computeIfAbsent(category, c -> new StructureSpawnOverrideBuilder(class_7061.class_7062.field_37199, Collections.emptyList()));
    }

    public void removeSpawnOverrides(class_1311 category) {
        this.spawnOverrides.remove(category);
    }

    public class_2893.class_2895 getDecorationStep() {
        return this.step;
    }

    public void setDecorationStep(class_2893.class_2895 step) {
        this.step = step;
    }

    public class_5847 getTerrainAdaptation() {
        return this.terrainAdaptation;
    }

    public void setTerrainAdaptation(class_5847 terrainAdaptation) {
        this.terrainAdaptation = terrainAdaptation;
    }

    public static class StructureSpawnOverrideBuilder {
        private class_7061.class_7062 boundingBox;
        private final List<class_5483.class_1964> spawns;
        private final List<class_5483.class_1964> spawnsView;

        public static StructureSpawnOverrideBuilder copyOf(class_7061 override) {
            return new StructureSpawnOverrideBuilder(override.comp_514(), override.comp_515().method_34994());
        }

        private StructureSpawnOverrideBuilder(class_7061.class_7062 boundingBox, List<class_5483.class_1964> spawns) {
            this.boundingBox = boundingBox;
            this.spawns = new ArrayList<class_5483.class_1964>(spawns);
            this.spawnsView = Collections.unmodifiableList(this.spawns);
        }

        public class_7061.class_7062 getBoundingBox() {
            return this.boundingBox;
        }

        public void setBoundingBox(class_7061.class_7062 boundingBox) {
            this.boundingBox = boundingBox;
        }

        public List<class_5483.class_1964> getSpawns() {
            return this.spawnsView;
        }

        public void addSpawn(class_5483.class_1964 spawn) {
            this.spawns.add(spawn);
        }

        public void removeSpawn(class_5483.class_1964 spawn) {
            this.spawns.remove(spawn);
        }

        public class_7061 build() {
            return new class_7061(this.boundingBox, class_6012.method_34988(this.spawns));
        }
    }
}

