/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_2902;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

public class SpawnPlacementRegisterEvent
extends Event
implements IModBusEvent {
    private final Map<class_1299<?>, MergedSpawnPredicate<?>> map;

    @ApiStatus.Internal
    public SpawnPlacementRegisterEvent(Map<class_1299<?>, MergedSpawnPredicate<?>> map) {
        this.map = map;
    }

    public <T extends class_1297> void register(class_1299<T> entityType, class_1317.class_4306<T> predicate) {
        this.register(entityType, null, null, predicate, Operation.OR);
    }

    public <T extends class_1297> void register(class_1299<T> entityType, class_1317.class_4306<T> predicate, Operation operation) {
        this.register(entityType, null, null, predicate, operation);
    }

    public <T extends class_1297> void register(class_1299<T> entityType, @Nullable class_1317.class_1319 placementType, @Nullable class_2902.class_2903 heightmap, class_1317.class_4306<T> predicate, Operation operation) {
        if (!this.map.containsKey(entityType)) {
            if (placementType == null) {
                throw new NullPointerException("Registering a new Spawn Predicate requires a nonnull placement type! Entity Type: " + String.valueOf(ForgeRegistries.ENTITY_TYPES.getKey(entityType)));
            }
            if (heightmap == null) {
                throw new NullPointerException("Registering a new Spawn Predicate requires a nonnull heightmap type! Entity Type: " + String.valueOf(ForgeRegistries.ENTITY_TYPES.getKey(entityType)));
            }
            this.map.put(entityType, new MergedSpawnPredicate<T>(predicate, placementType, heightmap));
        } else {
            if (operation != Operation.REPLACE && (heightmap != null || placementType != null)) {
                throw new IllegalStateException("Nonnull heightmap types or spawn placement types may only be used with the REPLACE operation. Entity Type: " + String.valueOf(ForgeRegistries.ENTITY_TYPES.getKey(entityType)));
            }
            this.map.get(entityType).merge(operation, predicate, placementType, heightmap);
        }
    }

    public static enum Operation {
        AND,
        OR,
        REPLACE;

    }

    public static class MergedSpawnPredicate<T extends class_1297> {
        private final class_1317.class_4306<T> originalPredicate;
        private final List<class_1317.class_4306<T>> orPredicates;
        private final List<class_1317.class_4306<T>> andPredicates;
        @Nullable
        private class_1317.class_4306<T> replacementPredicate;
        private class_1317.class_1319 spawnType;
        private class_2902.class_2903 heightmapType;

        public MergedSpawnPredicate(class_1317.class_4306<T> originalPredicate, class_1317.class_1319 spawnType, class_2902.class_2903 heightmapType) {
            this.originalPredicate = originalPredicate;
            this.orPredicates = new ArrayList<class_1317.class_4306<T>>();
            this.andPredicates = new ArrayList<class_1317.class_4306<T>>();
            this.replacementPredicate = null;
            this.spawnType = spawnType;
            this.heightmapType = heightmapType;
        }

        public class_1317.class_1319 getSpawnType() {
            return this.spawnType;
        }

        public class_2902.class_2903 getHeightmapType() {
            return this.heightmapType;
        }

        private void merge(Operation operation, class_1317.class_4306<T> predicate, @Nullable class_1317.class_1319 spawnType, @Nullable class_2902.class_2903 heightmapType) {
            if (operation == Operation.AND) {
                this.andPredicates.add(predicate);
            } else if (operation == Operation.OR) {
                this.orPredicates.add(predicate);
            } else if (operation == Operation.REPLACE) {
                this.replacementPredicate = predicate;
                if (spawnType != null) {
                    this.spawnType = spawnType;
                }
                if (heightmapType != null) {
                    this.heightmapType = heightmapType;
                }
            }
        }

        @ApiStatus.Internal
        public class_1317.class_4306<T> build() {
            if (this.replacementPredicate != null) {
                return this.replacementPredicate;
            }
            class_1317.class_4306<T> original = this.originalPredicate;
            class_1317.class_4306 compiledOrPredicate = (entityType, level, spawnType, pos, random) -> {
                if (original.test(entityType, level, spawnType, pos, random)) {
                    return true;
                }
                for (class_1317.class_4306<T> predicate : this.orPredicates) {
                    if (!predicate.test(entityType, level, spawnType, pos, random)) continue;
                    return true;
                }
                return false;
            };
            class_1317.class_4306 compiledAndPredicate = (entityType, level, spawnType, pos, random) -> {
                if (!compiledOrPredicate.test(entityType, level, spawnType, pos, random)) {
                    return false;
                }
                for (class_1317.class_4306<T> predicate : this.andPredicates) {
                    if (predicate.test(entityType, level, spawnType, pos, random)) continue;
                    return false;
                }
                return true;
            };
            return compiledAndPredicate;
        }
    }
}

