/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import java.io.File;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5321;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerEvent
extends LivingEvent {
    private final class_1657 player;

    public PlayerEvent(class_1657 player) {
        super((class_1309)player);
        this.player = player;
    }

    public class_1657 getEntity() {
        return this.player;
    }

    @Cancelable
    public static class PlayerChangeGameModeEvent
    extends PlayerEvent {
        private final class_1934 currentGameMode;
        private class_1934 newGameMode;

        public PlayerChangeGameModeEvent(class_1657 player, class_1934 currentGameMode, class_1934 newGameMode) {
            super(player);
            this.currentGameMode = currentGameMode;
            this.newGameMode = newGameMode;
        }

        public class_1934 getCurrentGameMode() {
            return this.currentGameMode;
        }

        public class_1934 getNewGameMode() {
            return this.newGameMode;
        }

        public void setNewGameMode(class_1934 newGameMode) {
            this.newGameMode = newGameMode;
        }
    }

    public static class PlayerChangedDimensionEvent
    extends PlayerEvent {
        private final class_5321<class_1937> fromDim;
        private final class_5321<class_1937> toDim;

        public PlayerChangedDimensionEvent(class_1657 player, class_5321<class_1937> fromDim, class_5321<class_1937> toDim) {
            super(player);
            this.fromDim = fromDim;
            this.toDim = toDim;
        }

        public class_5321<class_1937> getFrom() {
            return this.fromDim;
        }

        public class_5321<class_1937> getTo() {
            return this.toDim;
        }
    }

    public static class PlayerRespawnEvent
    extends PlayerEvent {
        private final boolean endConquered;

        public PlayerRespawnEvent(class_1657 player, boolean endConquered) {
            super(player);
            this.endConquered = endConquered;
        }

        public boolean isEndConquered() {
            return this.endConquered;
        }
    }

    public static class PlayerLoggedOutEvent
    extends PlayerEvent {
        public PlayerLoggedOutEvent(class_1657 player) {
            super(player);
        }
    }

    public static class PlayerLoggedInEvent
    extends PlayerEvent {
        public PlayerLoggedInEvent(class_1657 player) {
            super(player);
        }
    }

    public static class ItemSmeltedEvent
    extends PlayerEvent {
        @NotNull
        private final class_1799 smelting;

        public ItemSmeltedEvent(class_1657 player, @NotNull class_1799 crafting) {
            super(player);
            this.smelting = crafting;
        }

        @NotNull
        public class_1799 getSmelting() {
            return this.smelting;
        }
    }

    public static class ItemCraftedEvent
    extends PlayerEvent {
        @NotNull
        private final class_1799 crafting;
        private final class_1263 craftMatrix;

        public ItemCraftedEvent(class_1657 player, @NotNull class_1799 crafting, class_1263 craftMatrix) {
            super(player);
            this.crafting = crafting;
            this.craftMatrix = craftMatrix;
        }

        @NotNull
        public class_1799 getCrafting() {
            return this.crafting;
        }

        public class_1263 getInventory() {
            return this.craftMatrix;
        }
    }

    public static class ItemPickupEvent
    extends PlayerEvent {
        private final class_1542 originalEntity;
        private final class_1799 stack;

        public ItemPickupEvent(class_1657 player, class_1542 entPickedUp, class_1799 stack) {
            super(player);
            this.originalEntity = entPickedUp;
            this.stack = stack;
        }

        public class_1799 getStack() {
            return this.stack;
        }

        public class_1542 getOriginalEntity() {
            return this.originalEntity;
        }
    }

    public static class SaveToFile
    extends PlayerEvent {
        private final File playerDirectory;
        private final String playerUUID;

        public SaveToFile(class_1657 player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.playerDirectory;
        }

        public String getPlayerUUID() {
            return this.playerUUID;
        }
    }

    public static class LoadFromFile
    extends PlayerEvent {
        private final File playerDirectory;
        private final String playerUUID;

        public LoadFromFile(class_1657 player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.playerDirectory;
        }

        public String getPlayerUUID() {
            return this.playerUUID;
        }
    }

    public static class StopTracking
    extends PlayerEvent {
        private final class_1297 target;

        public StopTracking(class_1657 player, class_1297 target) {
            super(player);
            this.target = target;
        }

        public class_1297 getTarget() {
            return this.target;
        }
    }

    public static class StartTracking
    extends PlayerEvent {
        private final class_1297 target;

        public StartTracking(class_1657 player, class_1297 target) {
            super(player);
            this.target = target;
        }

        public class_1297 getTarget() {
            return this.target;
        }
    }

    public static class Clone
    extends PlayerEvent {
        private final class_1657 original;
        private final boolean wasDeath;

        public Clone(class_1657 _new, class_1657 oldPlayer, boolean wasDeath) {
            super(_new);
            this.original = oldPlayer;
            this.wasDeath = wasDeath;
        }

        public class_1657 getOriginal() {
            return this.original;
        }

        public boolean isWasDeath() {
            return this.wasDeath;
        }
    }

    public static class TabListNameFormat
    extends PlayerEvent {
        @Nullable
        private class_2561 displayName;

        public TabListNameFormat(class_1657 player) {
            super(player);
        }

        @Nullable
        public class_2561 getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(@Nullable class_2561 displayName) {
            this.displayName = displayName;
        }
    }

    public static class NameFormat
    extends PlayerEvent {
        private final class_2561 username;
        private class_2561 displayname;

        public NameFormat(class_1657 player, class_2561 username) {
            super(player);
            this.username = username;
            this.setDisplayname(username);
        }

        public class_2561 getUsername() {
            return this.username;
        }

        public class_2561 getDisplayname() {
            return this.displayname;
        }

        public void setDisplayname(class_2561 displayname) {
            this.displayname = displayname;
        }
    }

    @Cancelable
    public static class BreakSpeed
    extends PlayerEvent {
        private static final class_2338 LEGACY_UNKNOWN = new class_2338(0, -1, 0);
        private final class_2680 state;
        private final float originalSpeed;
        private float newSpeed = 0.0f;
        private final Optional<class_2338> pos;

        public BreakSpeed(class_1657 player, class_2680 state, float original, @Nullable class_2338 pos) {
            super(player);
            this.state = state;
            this.originalSpeed = original;
            this.setNewSpeed(original);
            this.pos = Optional.ofNullable(pos);
        }

        public class_2680 getState() {
            return this.state;
        }

        public float getOriginalSpeed() {
            return this.originalSpeed;
        }

        public float getNewSpeed() {
            return this.newSpeed;
        }

        public void setNewSpeed(float newSpeed) {
            this.newSpeed = newSpeed;
        }

        public Optional<class_2338> getPosition() {
            return this.pos;
        }
    }

    public static class HarvestCheck
    extends PlayerEvent {
        private final class_2680 state;
        private boolean success;

        public HarvestCheck(class_1657 player, class_2680 state, boolean success) {
            super(player);
            this.state = state;
            this.success = success;
        }

        public class_2680 getTargetBlock() {
            return this.state;
        }

        public boolean canHarvest() {
            return this.success;
        }

        public void setCanHarvest(boolean success) {
            this.success = success;
        }
    }
}

