/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import io.github.fabricators_of_create.porting_lib.fluids.FluidType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3610;
import net.minecraft.class_7;
import net.minecraft.class_7417;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.kilt.mixin.FluidTypeAccessor;

public class FluidType
extends io.github.fabricators_of_create.porting_lib.fluids.FluidType {
    public static final int BUCKET_VOLUME = 1000;
    private static final Map<FluidVariantAttributeHandler, FluidType> kilt$fluidTypes = new ConcurrentHashMap<FluidVariantAttributeHandler, FluidType>();
    public static final Lazy<Integer> SIZE = Lazy.of(() -> ForgeRegistries.FLUID_TYPES.get().getKeys().size());
    private static final Map<io.github.fabricators_of_create.porting_lib.fluids.FluidType, FluidType> kilt$wrappedFluidTypes = new ConcurrentHashMap<io.github.fabricators_of_create.porting_lib.fluids.FluidType, FluidType>();
    public io.github.fabricators_of_create.porting_lib.fluids.FluidType kilt$wrapped;
    public boolean kilt$isWrapped = false;
    private Object renderProperties;

    public static FluidType kilt$tryGetWrappingFluidType(FluidVariant fluidVariant, FluidVariantAttributeHandler handler) {
        return kilt$fluidTypes.computeIfAbsent(handler, $ -> {
            String string;
            class_2561 name = handler.getName(fluidVariant);
            Properties properties = Properties.create();
            class_7417 patt2988$temp = name.method_10851();
            if (patt2988$temp instanceof class_2588) {
                class_2588 translatable = (class_2588)patt2988$temp;
                string = translatable.method_11022();
            } else {
                string = name.getString();
            }
            Properties properties2 = properties.descriptionId(string).lightLevel(handler.getLuminance(fluidVariant)).temperature(handler.getTemperature(fluidVariant)).viscosity(handler.getViscosity(fluidVariant, null)).density(handler.isLighterThanAir(fluidVariant) ? 0 : 100);
            handler.getFillSound(fluidVariant).ifPresent(sound -> properties2.sound(SoundActions.BUCKET_FILL, (class_3414)sound));
            handler.getEmptySound(fluidVariant).ifPresent(sound -> properties2.sound(SoundActions.BUCKET_EMPTY, (class_3414)sound));
            return new FluidType(properties2, true);
        });
    }

    public static FluidType kilt$tryGetWrappingFluidType(io.github.fabricators_of_create.porting_lib.fluids.FluidType fabricFluidType) {
        if (fabricFluidType instanceof FluidType) {
            FluidType forgeFluidType = (FluidType)fabricFluidType;
            return forgeFluidType;
        }
        return kilt$wrappedFluidTypes.computeIfAbsent(fabricFluidType, FluidType::new);
    }

    public FluidType(Properties properties, boolean isWrapped) {
        this(properties);
        this.kilt$isWrapped = isWrapped;
    }

    private FluidType(io.github.fabricators_of_create.porting_lib.fluids.FluidType wrapped) {
        super(FluidType.Properties.create().descriptionId(wrapped.getDescriptionId()).motionScale(((FluidTypeAccessor)wrapped).getMotionScale()).canPushEntity(((FluidTypeAccessor)wrapped).isCanPushEntity()).canSwim(((FluidTypeAccessor)wrapped).isCanSwim()).canDrown(((FluidTypeAccessor)wrapped).isCanDrown()).fallDistanceModifier(((FluidTypeAccessor)wrapped).getFallDistanceModifier()).canExtinguish(((FluidTypeAccessor)wrapped).isCanExtinguish()).canConvertToSource(((FluidTypeAccessor)wrapped).isCanConvertToSource()).supportsBoating(((FluidTypeAccessor)wrapped).isSupportsBoating()).pathType(((FluidTypeAccessor)wrapped).getPathType()).adjacentPathType(((FluidTypeAccessor)wrapped).getAdjacentPathType()).canHydrate(((FluidTypeAccessor)wrapped).isCanHydrate()).lightLevel(((FluidTypeAccessor)wrapped).getLightLevel()).density(((FluidTypeAccessor)wrapped).getDensity()).temperature(((FluidTypeAccessor)wrapped).getTemperature()).viscosity(((FluidTypeAccessor)wrapped).getViscosity()).rarity(((FluidTypeAccessor)wrapped).getRarity()));
        this.kilt$wrapped = wrapped;
        this.initClient();
    }

    public FluidType(Properties properties) {
        super(FluidType.Properties.create().descriptionId(properties.descriptionId).motionScale(properties.motionScale).canPushEntity(properties.canPushEntity).canSwim(properties.canSwim).canDrown(properties.canDrown).fallDistanceModifier(properties.fallDistanceModifier).canExtinguish(properties.canExtinguish).canConvertToSource(properties.canConvertToSource).supportsBoating(properties.supportsBoating).pathType(properties.pathType).adjacentPathType(properties.adjacentPathType).canHydrate(properties.canHydrate).lightLevel(properties.lightLevel).density(properties.density).temperature(properties.temperature).viscosity(properties.viscosity).rarity(properties.rarity));
        this.initClient();
    }

    public String getDescriptionId() {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getDescriptionId();
        }
        if (((FluidTypeAccessor)((Object)this)).kilt$getDescriptionId() == null) {
            ((FluidTypeAccessor)((Object)this)).kilt$setDescriptionId(class_156.method_646((String)"fluid_type", (class_2960)ForgeRegistries.FLUID_TYPES.get().getKey(this)));
        }
        return ((FluidTypeAccessor)((Object)this)).kilt$getDescriptionId();
    }

    @Nullable
    public class_3414 getSound(SoundAction action) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getSound(action.asFabric());
        }
        return (class_3414)this.sounds.get(action.asFabric());
    }

    public boolean supportsBoating(class_3610 state, class_1690 boat) {
        return this.supportsBoating(boat);
    }

    public boolean shouldUpdateWhileBoating(class_3610 state, class_1690 boat, class_1297 rider) {
        return !this.supportsBoating(state, boat);
    }

    public boolean canRideVehicleUnder(class_1297 vehicle, class_1297 rider) {
        if (this == ForgeMod.WATER_TYPE.get()) {
            return !vehicle.method_49693();
        }
        return true;
    }

    public boolean canHydrate(class_1297 entity) {
        return ((FluidTypeAccessor)((Object)this)).isCanHydrate();
    }

    @Nullable
    public class_3414 getSound(class_1297 entity, SoundAction action) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getSound(entity, action.asFabric());
        }
        return this.getSound(entity, action.asFabric());
    }

    @Nullable
    public class_3414 getSound(@Nullable class_1657 player, class_1922 getter, class_2338 pos, SoundAction action) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getSound(player, getter, pos, action.asFabric());
        }
        return this.getSound(player, getter, pos, action.asFabric());
    }

    public boolean canConvertToSource(FluidStack stack) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.canConvertToSource((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
        }
        return this.canConvertToSource(stack);
    }

    @Nullable
    public class_3414 getSound(FluidStack stack, SoundAction action) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getSound((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack, action.asFabric());
        }
        return this.getSound(action.asFabric());
    }

    public class_2561 getDescription(FluidStack stack) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getDescription((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
        }
        return class_2561.method_43471((String)this.getDescriptionId(stack));
    }

    public String getDescriptionId(FluidStack stack) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getDescriptionId((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
        }
        return this.getDescriptionId();
    }

    public boolean canHydrate(FluidStack stack) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.canHydrate((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
        }
        return this.canHydrate(stack);
    }

    public int getLightLevel(FluidStack stack) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getLightLevel((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
        }
        return this.getLightLevel(stack);
    }

    public int getDensity(FluidStack stack) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getDensity((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
        }
        return this.getDensity(stack);
    }

    public int getTemperature(FluidStack stack) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getTemperature((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
        }
        return this.getTemperature(stack);
    }

    public int getViscosity(FluidStack stack) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getViscosity((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
        }
        return this.getViscosity(stack);
    }

    public class_1814 getRarity(FluidStack stack) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getRarity((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
        }
        return this.getRarity(stack);
    }

    public class_1799 getBucket(FluidStack stack) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getBucket((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
        }
        return this.getBucket(stack);
    }

    public class_3610 getStateForPlacement(class_1920 getter, class_2338 pos, FluidStack stack) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.getStateForPlacement(getter, pos, (io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
        }
        return this.getStateForPlacement(getter, pos, stack);
    }

    public final boolean canBePlacedInLevel(class_1920 getter, class_2338 pos, FluidStack stack) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.canBePlacedInLevel(getter, pos, (io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
        }
        return this.canBePlacedInLevel(getter, pos, stack);
    }

    public boolean isVaporizedOnPlacement(class_1937 level, class_2338 pos, FluidStack stack) {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.isVaporizedOnPlacement(level, pos, (io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
        }
        return this.isVaporizedOnPlacement(level, pos, stack);
    }

    public void onVaporize(@Nullable class_1657 player, class_1937 level, class_2338 pos, FluidStack stack) {
        if (this.kilt$wrapped != null) {
            this.kilt$wrapped.onVaporize(player, level, pos, (io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stack);
            return;
        }
        this.onVaporize(player, level, pos, stack);
    }

    public String toString() {
        if (this.kilt$wrapped != null) {
            return this.kilt$wrapped.toString();
        }
        @Nullable class_2960 name = ForgeRegistries.FLUID_TYPES.get().getKey(this);
        return name != null ? name.toString() : "Unregistered FluidType";
    }

    public Object getRenderPropertiesInternal() {
        return this.renderProperties;
    }

    private void initClient() {
        if (FMLEnvironment.dist == Dist.CLIENT && !FMLLoader.getLaunchHandler().isData()) {
            this.initializeClient(properties -> {
                if (properties == this) {
                    throw new IllegalStateException("Don't extend IFluidTypeRenderProperties in your fluid type, use an anonymous class instead.");
                }
                this.renderProperties = properties;
            });
        }
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
    }

    public static final class Properties {
        private String descriptionId;
        private double motionScale = 0.014;
        private boolean canPushEntity = true;
        private boolean canSwim = true;
        private boolean canDrown = true;
        private float fallDistanceModifier = 0.5f;
        private boolean canExtinguish = false;
        private boolean canConvertToSource = false;
        private boolean supportsBoating = false;
        @Nullable
        private class_7 pathType = class_7.field_18;
        @Nullable
        private class_7 adjacentPathType = class_7.field_4;
        private final Map<SoundAction, class_3414> sounds = new HashMap<SoundAction, class_3414>();
        private boolean canHydrate = false;
        private int lightLevel = 0;
        private int density = 1000;
        private int temperature = 300;
        private int viscosity = 1000;
        private class_1814 rarity = class_1814.field_8906;

        private Properties() {
        }

        public static Properties create() {
            return new Properties();
        }

        public Properties descriptionId(String descriptionId) {
            this.descriptionId = descriptionId;
            return this;
        }

        public Properties motionScale(double motionScale) {
            this.motionScale = motionScale;
            return this;
        }

        public Properties canPushEntity(boolean canPushEntity) {
            this.canPushEntity = canPushEntity;
            return this;
        }

        public Properties canSwim(boolean canSwim) {
            this.canSwim = canSwim;
            return this;
        }

        public Properties canDrown(boolean canDrown) {
            this.canDrown = canDrown;
            return this;
        }

        public Properties fallDistanceModifier(float fallDistanceModifier) {
            this.fallDistanceModifier = fallDistanceModifier;
            return this;
        }

        public Properties canExtinguish(boolean canExtinguish) {
            this.canExtinguish = canExtinguish;
            return this;
        }

        public Properties canConvertToSource(boolean canConvertToSource) {
            this.canConvertToSource = canConvertToSource;
            return this;
        }

        public Properties supportsBoating(boolean supportsBoating) {
            this.supportsBoating = supportsBoating;
            return this;
        }

        public Properties pathType(@Nullable class_7 pathType) {
            this.pathType = pathType;
            return this;
        }

        public Properties adjacentPathType(@Nullable class_7 adjacentPathType) {
            this.adjacentPathType = adjacentPathType;
            return this;
        }

        public Properties sound(SoundAction action, class_3414 sound) {
            this.sounds.put(action, sound);
            return this;
        }

        public Properties canHydrate(boolean canHydrate) {
            this.canHydrate = canHydrate;
            return this;
        }

        public Properties lightLevel(int lightLevel) {
            if (lightLevel < 0 || lightLevel > 15) {
                throw new IllegalArgumentException("The light level should be between [0,15].");
            }
            this.lightLevel = lightLevel;
            return this;
        }

        public Properties density(int density) {
            this.density = density;
            return this;
        }

        public Properties temperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        public Properties viscosity(int viscosity) {
            if (viscosity < 0) {
                throw new IllegalArgumentException("The viscosity should never be negative.");
            }
            this.viscosity = viscosity;
            return this;
        }

        public Properties rarity(class_1814 rarity) {
            this.rarity = rarity;
            return this;
        }
    }
}

