/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.wrappers;

import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_3610;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BucketPickupHandlerWrapper
implements IFluidHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final class_2263 bucketPickupHandler;
    protected final class_1937 world;
    protected final class_2338 blockPos;

    public BucketPickupHandlerWrapper(class_2263 bucketPickupHandler, class_1937 world, class_2338 blockPos) {
        this.bucketPickupHandler = bucketPickupHandler;
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    @NotNull
    public FluidStack getFluidInTank(int tank) {
        class_3610 fluidState;
        if (tank == 0 && !(fluidState = this.world.method_8316(this.blockPos)).method_15769()) {
            return new FluidStack(fluidState.method_15772(), 1000);
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int getTankCapacity(int tank) {
        return 1000;
    }

    @Override
    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Override
    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        class_3610 fluidState;
        if (!resource.isEmpty() && 1000L <= resource.getAmount() && !(fluidState = this.world.method_8316(this.blockPos)).method_15769() && resource.getFluid() == fluidState.method_15772()) {
            if (action.execute()) {
                class_1792 class_17922;
                class_1799 itemStack = this.bucketPickupHandler.method_9700((class_1936)this.world, this.blockPos, this.world.method_8320(this.blockPos));
                if (itemStack != class_1799.field_8037 && (class_17922 = itemStack.method_7909()) instanceof class_1755) {
                    class_1755 bucket = (class_1755)class_17922;
                    FluidStack extracted = new FluidStack(bucket.getFluid(), 1000);
                    if (!resource.isFluidEqual(extracted)) {
                        LOGGER.error("Fluid removed without successfully being picked up. Fluid {} at {} in {} matched requested type, but after performing pickup was {}.", (Object)ForgeRegistries.FLUIDS.getKey(fluidState.method_15772()), (Object)this.blockPos, (Object)this.world.method_27983().method_29177(), (Object)ForgeRegistries.FLUIDS.getKey(bucket.getFluid()));
                        return FluidStack.EMPTY;
                    }
                    return extracted;
                }
            } else {
                FluidStack extracted = new FluidStack(fluidState.method_15772(), 1000);
                if (resource.isFluidEqual(extracted)) {
                    return extracted;
                }
            }
        }
        return FluidStack.EMPTY;
    }

    @Override
    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        class_3610 fluidState;
        if (1000 <= maxDrain && !(fluidState = this.world.method_8316(this.blockPos)).method_15769()) {
            class_1792 class_17922;
            if (action.simulate()) {
                return new FluidStack(fluidState.method_15772(), 1000);
            }
            class_1799 itemStack = this.bucketPickupHandler.method_9700((class_1936)this.world, this.blockPos, this.world.method_8320(this.blockPos));
            if (itemStack != class_1799.field_8037 && (class_17922 = itemStack.method_7909()) instanceof class_1755) {
                class_1755 bucket = (class_1755)class_17922;
                return new FluidStack(bucket.getFluid(), 1000);
            }
        }
        return FluidStack.EMPTY;
    }
}

