/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u001a\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u00020\u00158\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\r8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lnet/minecraftforge/fml/ModWorkManager;", "", "<init>", "()V", "Lnet/minecraftforge/fml/ModWorkManager$DrivenExecutor;", "syncExecutor", "()Lnet/minecraftforge/fml/ModWorkManager$DrivenExecutor;", "Ljava/util/concurrent/Executor;", "executor", "wrappedExecutor", "(Ljava/util/concurrent/Executor;)Lnet/minecraftforge/fml/ModWorkManager$DrivenExecutor;", "parallelExecutor", "()Ljava/util/concurrent/Executor;", "Ljava/util/concurrent/ForkJoinPool;", "pool", "Ljava/util/concurrent/ForkJoinWorkerThread;", "newForkJoinWorkerThread", "(Ljava/util/concurrent/ForkJoinPool;)Ljava/util/concurrent/ForkJoinWorkerThread;", "", "PARK_TIME", "J", "Lnet/minecraftforge/fml/ModWorkManager$SyncExecutor;", "syncExec", "Lnet/minecraftforge/fml/ModWorkManager$SyncExecutor;", "threadPool", "Ljava/util/concurrent/ForkJoinPool;", "DrivenExecutor", "SyncExecutor", "WrappingExecutor", "Kilt"})
public final class ModWorkManager {
    @NotNull
    public static final ModWorkManager INSTANCE = new ModWorkManager();
    private static final long PARK_TIME = TimeUnit.MILLISECONDS.toNanos(1L);
    private static SyncExecutor syncExec;
    private static ForkJoinPool threadPool;

    private ModWorkManager() {
    }

    @JvmStatic
    @NotNull
    public static final DrivenExecutor syncExecutor() {
        SyncExecutor syncExecutor;
        if (syncExec == null) {
            syncExec = new SyncExecutor();
        }
        if ((syncExecutor = syncExec) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"syncExec");
            syncExecutor = null;
        }
        return syncExecutor;
    }

    @JvmStatic
    @NotNull
    public static final DrivenExecutor wrappedExecutor(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return new WrappingExecutor(executor);
    }

    @JvmStatic
    @NotNull
    public static final Executor parallelExecutor() {
        ForkJoinPool forkJoinPool;
        if (threadPool == null) {
            int loadingThreadCount = Runtime.getRuntime().availableProcessors();
            threadPool = new ForkJoinPool(loadingThreadCount, INSTANCE::newForkJoinWorkerThread, null, false);
        }
        if ((forkJoinPool = threadPool) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"threadPool");
            forkJoinPool = null;
        }
        return forkJoinPool;
    }

    private final ForkJoinWorkerThread newForkJoinWorkerThread(ForkJoinPool pool) {
        ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
        thread.setName("kilt-modloading-worker-" + thread.getPoolIndex());
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        Intrinsics.checkNotNull((Object)thread);
        return thread;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u000f\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b\u00c0\u0006\u0003"}, d2={"Lnet/minecraftforge/fml/ModWorkManager$DrivenExecutor;", "Ljava/util/concurrent/Executor;", "", "selfDriven", "()Z", "driveOne", "Ljava/lang/Runnable;", "ticker", "", "drive", "(Ljava/lang/Runnable;)V", "Kilt"})
    public static interface DrivenExecutor
    extends Executor {
        public boolean selfDriven();

        public boolean driveOne();

        default public void drive(@NotNull Runnable ticker) {
            Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
            if (!this.selfDriven()) {
                while (this.driveOne()) {
                    ticker.run();
                }
            } else {
                LockSupport.parkNanos(PARK_TIME);
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            public static void drive(@NotNull DrivenExecutor $this, @NotNull Runnable ticker) {
                Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
                $this.drive(ticker);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/minecraftforge/fml/ModWorkManager$SyncExecutor;", "Lnet/minecraftforge/fml/ModWorkManager$DrivenExecutor;", "<init>", "()V", "", "selfDriven", "()Z", "driveOne", "Ljava/lang/Runnable;", "p0", "", "execute", "(Ljava/lang/Runnable;)V", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "tasks", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Kilt"})
    private static final class SyncExecutor
    implements DrivenExecutor {
        @NotNull
        private final ConcurrentLinkedDeque<Runnable> tasks = new ConcurrentLinkedDeque();

        @Override
        public boolean selfDriven() {
            return false;
        }

        @Override
        public boolean driveOne() {
            Runnable task;
            block0: {
                Runnable runnable = task = this.tasks.pollFirst();
                if (runnable == null) break block0;
                runnable.run();
            }
            return task != null;
        }

        @Override
        public void execute(@NotNull Runnable p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            this.tasks.addLast(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/minecraftforge/fml/ModWorkManager$WrappingExecutor;", "Lnet/minecraftforge/fml/ModWorkManager$DrivenExecutor;", "Ljava/util/concurrent/Executor;", "wrapped", "<init>", "(Ljava/util/concurrent/Executor;)V", "", "selfDriven", "()Z", "driveOne", "Ljava/lang/Runnable;", "p0", "", "execute", "(Ljava/lang/Runnable;)V", "Ljava/util/concurrent/Executor;", "Kilt"})
    private static final class WrappingExecutor
    implements DrivenExecutor {
        @NotNull
        private final Executor wrapped;

        public WrappingExecutor(@NotNull Executor wrapped) {
            Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
            this.wrapped = wrapped;
        }

        @Override
        public boolean selfDriven() {
            return true;
        }

        @Override
        public boolean driveOne() {
            return false;
        }

        @Override
        public void execute(@NotNull Runnable p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            this.wrapped.execute(p0);
        }
    }
}

