/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\u0007J+\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00042\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\n\"\u00020\u0004H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J+\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0014H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lnet/minecraftforge/fml/loading/StringUtils;", "", "<init>", "()V", "", "str", "toLowerCase", "(Ljava/lang/String;)Ljava/lang/String;", "toUpperCase", "search", "", "endings", "", "endsWith", "(Ljava/lang/String;[Ljava/lang/String;)Z", "string", "Ljava/net/URL;", "toURL", "(Ljava/lang/String;)Ljava/net/URL;", "input", "", "properties", "parseStringFormat", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;", "", "bytes", "binToHex", "([B)Ljava/lang/String;", "Kilt"})
@SourceDebugExtension(value={"SMAP\nStringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtils.kt\nnet/minecraftforge/fml/loading/StringUtils\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,56:1\n106#2:57\n78#2,22:58\n*S KotlinDebug\n*F\n+ 1 StringUtils.kt\nnet/minecraftforge/fml/loading/StringUtils\n*L\n32#1:57\n32#1:58,22\n*E\n"})
public final class StringUtils {
    @NotNull
    public static final StringUtils INSTANCE = new StringUtils();

    private StringUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String toLowerCase(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String string = str.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String toUpperCase(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String string = str.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }

    @JvmStatic
    public static final boolean endsWith(@NotNull String search, String ... endings) {
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)endings, (String)"endings");
        String lowerSearch = StringUtils.toLowerCase(search);
        return Stream.of(Arrays.copyOf(endings, endings.length)).anyMatch(arg_0 -> StringUtils.endsWith$lambda$1(arg_0 -> StringUtils.endsWith$lambda$0(lowerSearch, arg_0), arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final URL toURL(@Nullable String string) {
        URL uRL;
        if (string == null) return null;
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) {
            return null;
        }
        boolean bl = false;
        if (bl) return null;
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"myurl.me", (boolean)false, (int)2, null)) return null;
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"example.invalid", (boolean)false, (int)2, null)) {
            return null;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        URL uRL2 = uRL;
        return uRL2;
    }

    @JvmStatic
    @NotNull
    public static final String parseStringFormat(@NotNull String input, @NotNull Map<String, String> properties) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        String string = StrSubstitutor.replace((Object)input, properties);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String binToHex(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        StringBuilder sb = new StringBuilder();
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            sb.append(Integer.toHexString((bytes[i] & 0xF0) >> 4));
            sb.append(Integer.toHexString(bytes[i] & 0xF));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final boolean endsWith$lambda$0(String $lowerSearch, String suffix) {
        String string = suffix;
        Intrinsics.checkNotNull((Object)string);
        return StringsKt.endsWith$default((String)$lowerSearch, (String)string, (boolean)false, (int)2, null);
    }

    private static final boolean endsWith$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

