/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items.wrapper;

import net.minecraft.class_1262;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ShulkerItemStackInvWrapper
implements IItemHandlerModifiable,
ICapabilityProvider {
    private final class_1799 stack;
    private final LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this);
    private class_2487 cachedTag;
    private class_2371<class_1799> itemStacksCache;

    @ApiStatus.Internal
    @Nullable
    public static ICapabilityProvider createDefaultProvider(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item == class_1802.field_8545 || item == class_1802.field_8268 || item == class_1802.field_8350 || item == class_1802.field_8584 || item == class_1802.field_8213 || item == class_1802.field_8627 || item == class_1802.field_8461 || item == class_1802.field_8829 || item == class_1802.field_8451 || item == class_1802.field_8548 || item == class_1802.field_8050 || item == class_1802.field_8380 || item == class_1802.field_8520 || item == class_1802.field_8816 || item == class_1802.field_8676 || item == class_1802.field_8722 || item == class_1802.field_8271) {
            return new ShulkerItemStackInvWrapper(itemStack);
        }
        return null;
    }

    private ShulkerItemStackInvWrapper(class_1799 stack) {
        this.stack = stack;
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    @NotNull
    public class_1799 getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (class_1799)this.getItemList().get(slot);
    }

    @Override
    @NotNull
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        class_2371<class_1799> itemStacks = this.getItemList();
        class_1799 existing = (class_1799)itemStacks.get(slot);
        int limit = Math.min(this.getSlotLimit(slot), stack.method_7914());
        if (!existing.method_7960()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.method_7947();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.method_7947() > limit;
        if (!simulate) {
            if (existing.method_7960()) {
                itemStacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack));
            } else {
                existing.method_7933(reachedLimit ? limit : stack.method_7947());
            }
            this.setItemList(itemStacks);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.method_7947() - limit) : class_1799.field_8037;
    }

    @Override
    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        class_2371<class_1799> itemStacks = this.getItemList();
        if (amount == 0) {
            return class_1799.field_8037;
        }
        this.validateSlotIndex(slot);
        class_1799 existing = (class_1799)itemStacks.get(slot);
        if (existing.method_7960()) {
            return class_1799.field_8037;
        }
        int toExtract = Math.min(amount, existing.method_7914());
        if (existing.method_7947() <= toExtract) {
            if (!simulate) {
                itemStacks.set(slot, (Object)class_1799.field_8037);
                this.setItemList(itemStacks);
                return existing;
            }
            return existing.method_7972();
        }
        if (!simulate) {
            itemStacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize(existing, existing.method_7947() - toExtract));
            this.setItemList(itemStacks);
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        return stack.method_7909().method_31568();
    }

    @Override
    public void setStackInSlot(int slot, @NotNull class_1799 stack) {
        this.validateSlotIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            throw new RuntimeException("Invalid stack " + String.valueOf(stack) + " for slot " + slot + ")");
        }
        class_2371<class_1799> itemStacks = this.getItemList();
        itemStacks.set(slot, (Object)stack);
        this.setItemList(itemStacks);
    }

    private class_2371<class_1799> getItemList() {
        class_2487 rootTag = class_1747.method_38072((class_1799)this.stack);
        if (this.cachedTag == null || !this.cachedTag.equals((Object)rootTag)) {
            this.itemStacksCache = this.refreshItemList(rootTag);
        }
        return this.itemStacksCache;
    }

    private class_2371<class_1799> refreshItemList(class_2487 rootTag) {
        class_2371 itemStacks = class_2371.method_10213((int)this.getSlots(), (Object)class_1799.field_8037);
        if (rootTag != null && rootTag.method_10573("Items", 9)) {
            class_1262.method_5429((class_2487)rootTag, (class_2371)itemStacks);
        }
        this.cachedTag = rootTag;
        return itemStacks;
    }

    private void setItemList(class_2371<class_1799> itemStacks) {
        class_2487 existing = class_1747.method_38072((class_1799)this.stack);
        class_2487 rootTag = class_1262.method_5426((class_2487)(existing == null ? new class_2487() : existing), itemStacks);
        class_1747.method_38073((class_1799)this.stack, (class_2591)class_2591.field_11896, (class_2487)rootTag);
        this.cachedTag = rootTag;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable class_2350 side) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
    }
}

