/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.registries.DataPackRegistriesHooks;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class HandshakeMessages {

    public static class S2CChannelMismatchData
    extends LoginIndexedMessage {
        private final Map<class_2960, String> mismatchedChannelData;

        public S2CChannelMismatchData(Map<class_2960, String> mismatchedChannelData) {
            this.mismatchedChannelData = mismatchedChannelData;
        }

        public static S2CChannelMismatchData decode(class_2540 input) {
            Map mismatchedMods = input.method_34067(i -> new class_2960(i.method_10800(256)), i -> i.method_10800(256));
            return new S2CChannelMismatchData(mismatchedMods);
        }

        public void encode(class_2540 output) {
            output.method_34063(this.mismatchedChannelData, (o, r) -> o.method_10788(r.toString(), 256), (o, v) -> o.method_10788(v, 256));
        }

        public Map<class_2960, String> getMismatchedChannelData() {
            return this.mismatchedChannelData;
        }
    }

    public static class S2CConfigData
    extends LoginIndexedMessage {
        private final String fileName;
        private final byte[] fileData;

        public S2CConfigData(String configFileName, byte[] configFileData) {
            this.fileName = configFileName;
            this.fileData = configFileData;
        }

        void encode(class_2540 buffer) {
            buffer.method_10814(this.fileName);
            buffer.method_10813(this.fileData);
        }

        public static S2CConfigData decode(class_2540 buffer) {
            return new S2CConfigData(buffer.method_10800(Short.MAX_VALUE), buffer.method_10795());
        }

        public String getFileName() {
            return this.fileName;
        }

        public byte[] getBytes() {
            return this.fileData;
        }
    }

    public static class S2CRegistry
    extends LoginIndexedMessage {
        private class_2960 registryName;
        @Nullable
        private ForgeRegistry.Snapshot snapshot;

        public S2CRegistry(class_2960 name, @Nullable ForgeRegistry.Snapshot snapshot) {
            this.registryName = name;
            this.snapshot = snapshot;
        }

        void encode(class_2540 buffer) {
            buffer.method_10812(this.registryName);
            buffer.writeBoolean(this.hasSnapshot());
            if (this.hasSnapshot()) {
                buffer.writeBytes((ByteBuf)this.snapshot.getPacketData());
            }
        }

        public static S2CRegistry decode(class_2540 buffer) {
            class_2960 name = buffer.method_10810();
            ForgeRegistry.Snapshot snapshot = null;
            if (buffer.readBoolean()) {
                snapshot = ForgeRegistry.Snapshot.read(buffer);
            }
            return new S2CRegistry(name, snapshot);
        }

        public class_2960 getRegistryName() {
            return this.registryName;
        }

        public boolean hasSnapshot() {
            return this.snapshot != null;
        }

        @Nullable
        public ForgeRegistry.Snapshot getSnapshot() {
            return this.snapshot;
        }
    }

    public static class C2SAcknowledge
    extends LoginIndexedMessage {
        public void encode(class_2540 buf) {
        }

        public static C2SAcknowledge decode(class_2540 buf) {
            return new C2SAcknowledge();
        }
    }

    public static class C2SModListReply
    extends LoginIndexedMessage {
        private List<String> mods;
        private Map<class_2960, String> channels;
        private Map<class_2960, String> registries;

        public C2SModListReply() {
            this.mods = ModList.get().getMods().stream().map(IModInfo::getModId).collect(Collectors.toList());
            this.channels = NetworkRegistry.buildChannelVersions();
            this.registries = Maps.newHashMap();
        }

        private C2SModListReply(List<String> mods, Map<class_2960, String> channels, Map<class_2960, String> registries) {
            this.mods = mods;
            this.channels = channels;
            this.registries = registries;
        }

        public static C2SModListReply decode(class_2540 input) {
            ArrayList<String> mods = new ArrayList<String>();
            int len = input.method_10816();
            for (int x = 0; x < len; ++x) {
                mods.add(input.method_10800(256));
            }
            HashMap<class_2960, String> channels = new HashMap<class_2960, String>();
            len = input.method_10816();
            for (int x = 0; x < len; ++x) {
                channels.put(input.method_10810(), input.method_10800(256));
            }
            HashMap<class_2960, String> registries = new HashMap<class_2960, String>();
            len = input.method_10816();
            for (int x = 0; x < len; ++x) {
                registries.put(input.method_10810(), input.method_10800(256));
            }
            return new C2SModListReply(mods, channels, registries);
        }

        public void encode(class_2540 output) {
            output.method_10804(this.mods.size());
            this.mods.forEach(m -> output.method_10788(m, 256));
            output.method_10804(this.channels.size());
            this.channels.forEach((k, v) -> {
                output.method_10812(k);
                output.method_10788(v, 256);
            });
            output.method_10804(this.registries.size());
            this.registries.forEach((k, v) -> {
                output.method_10812(k);
                output.method_10788(v, 256);
            });
        }

        public List<String> getModList() {
            return this.mods;
        }

        public Map<class_2960, String> getRegistries() {
            return this.registries;
        }

        public Map<class_2960, String> getChannels() {
            return this.channels;
        }
    }

    public static class S2CModData
    extends LoginIndexedMessage {
        private final Map<String, Pair<String, String>> mods;

        public S2CModData() {
            this.mods = ModList.get().getMods().stream().collect(Collectors.toMap(IModInfo::getModId, info -> Pair.of((Object)info.getDisplayName(), (Object)info.getVersion().toString())));
        }

        private S2CModData(Map<String, Pair<String, String>> mods) {
            this.mods = mods;
        }

        public static S2CModData decode(class_2540 input) {
            Map mods = input.method_34067(o -> o.method_10800(256), o -> Pair.of((Object)o.method_10800(256), (Object)o.method_10800(256)));
            return new S2CModData(mods);
        }

        public void encode(class_2540 output) {
            output.method_34063(this.mods, (o, s) -> o.method_10788(s, 256), (o, p) -> {
                o.method_10788((String)p.getLeft(), 256);
                o.method_10788((String)p.getRight(), 256);
            });
        }

        public Map<String, Pair<String, String>> getMods() {
            return this.mods;
        }
    }

    public static class S2CModList
    extends LoginIndexedMessage {
        private List<String> mods;
        private Map<class_2960, String> channels;
        private List<class_2960> registries;
        private final List<class_5321<? extends class_2378<?>>> dataPackRegistries;

        public S2CModList() {
            this.mods = ModList.get().getMods().stream().map(IModInfo::getModId).collect(Collectors.toList());
            this.channels = NetworkRegistry.buildChannelVersions();
            this.registries = RegistryManager.getRegistryNamesForSyncToClient();
            this.dataPackRegistries = List.copyOf(DataPackRegistriesHooks.getSyncedCustomRegistries());
        }

        private S2CModList(List<String> mods, Map<class_2960, String> channels, List<class_2960> registries, List<class_5321<? extends class_2378<?>>> dataPackRegistries) {
            this.mods = mods;
            this.channels = channels;
            this.registries = registries;
            this.dataPackRegistries = dataPackRegistries;
        }

        public static S2CModList decode(class_2540 input) {
            ArrayList<String> mods = new ArrayList<String>();
            int len = input.method_10816();
            for (int x = 0; x < len; ++x) {
                mods.add(input.method_10800(256));
            }
            HashMap<class_2960, String> channels = new HashMap<class_2960, String>();
            len = input.method_10816();
            for (int x = 0; x < len; ++x) {
                channels.put(input.method_10810(), input.method_10800(256));
            }
            ArrayList<class_2960> registries = new ArrayList<class_2960>();
            len = input.method_10816();
            for (int x = 0; x < len; ++x) {
                registries.add(input.method_10810());
            }
            List dataPackRegistries = (List)input.method_34068(ArrayList::new, buf -> class_5321.method_29180((class_2960)buf.method_10810()));
            return new S2CModList(mods, channels, registries, dataPackRegistries);
        }

        public void encode(class_2540 output) {
            output.method_10804(this.mods.size());
            this.mods.forEach(m -> output.method_10788(m, 256));
            output.method_10804(this.channels.size());
            this.channels.forEach((k, v) -> {
                output.method_10812(k);
                output.method_10788(v, 256);
            });
            output.method_10804(this.registries.size());
            this.registries.forEach(arg_0 -> ((class_2540)output).method_10812(arg_0));
            Set<class_5321<? extends class_2378<?>>> dataPackRegistries = DataPackRegistriesHooks.getSyncedCustomRegistries();
            output.method_34062(dataPackRegistries, (buf, key) -> buf.method_10812(key.method_29177()));
        }

        public List<String> getModList() {
            return this.mods;
        }

        public List<class_2960> getRegistries() {
            return this.registries;
        }

        public Map<class_2960, String> getChannels() {
            return this.channels;
        }

        public List<class_5321<? extends class_2378<?>>> getCustomDataPackRegistries() {
            return this.dataPackRegistries;
        }
    }

    static class LoginIndexedMessage
    implements IntSupplier {
        private int loginIndex;

        LoginIndexedMessage() {
        }

        void setLoginIndex(int loginIndex) {
            this.loginIndex = loginIndex;
        }

        int getLoginIndex() {
            return this.loginIndex;
        }

        @Override
        public int getAsInt() {
            return this.getLoginIndex();
        }
    }
}

