/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraftforge.network.HandshakeHandler;
import net.minecraftforge.network.NetworkConstants;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public class LoginWrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    @ApiStatus.Internal
    public static final class_2960 WRAPPER = new class_2960("fml:loginwrapper");
    private EventNetworkChannel wrapperChannel = NetworkRegistry.ChannelBuilder.named(WRAPPER).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "FML3").eventNetworkChannel();

    LoginWrapper() {
        this.wrapperChannel.addListener(this::wrapperReceived);
    }

    private <T extends NetworkEvent> void wrapperReceived(T packet) {
        if (packet instanceof NetworkEvent.ChannelRegistrationChangeEvent) {
            return;
        }
        NetworkEvent.Context wrappedContext = packet.getSource().get();
        class_2540 payload = packet.getPayload();
        class_2960 targetNetworkReceiver = NetworkConstants.FML_HANDSHAKE_RESOURCE;
        class_2540 data = null;
        if (payload != null) {
            targetNetworkReceiver = payload.method_10810();
            int payloadLength = payload.method_10816();
            data = new class_2540(payload.readBytes(payloadLength));
        }
        int loginSequence = packet.getLoginIndex();
        LOGGER.debug(HandshakeHandler.FMLHSMARKER, "Recieved login wrapper packet event for channel {} with index {}", (Object)targetNetworkReceiver, (Object)loginSequence);
        NetworkEvent.Context context = new NetworkEvent.Context(wrappedContext.getNetworkManager(), wrappedContext.getDirection(), (rl, buf) -> {
            LOGGER.debug(HandshakeHandler.FMLHSMARKER, "Dispatching wrapped packet reply for channel {} with index {}", rl, (Object)loginSequence);
            wrappedContext.getPacketDispatcher().sendPacket(WRAPPER, this.wrapPacket((class_2960)rl, (class_2540)buf));
        });
        NetworkEvent.LoginPayloadEvent loginPayloadEvent = new NetworkEvent.LoginPayloadEvent(data, () -> context, loginSequence);
        NetworkRegistry.findTarget(targetNetworkReceiver).ifPresent(ni -> {
            ni.dispatchLoginPacket(loginPayloadEvent);
            wrappedContext.setPacketHandled(context.getPacketHandled());
        });
    }

    private class_2540 wrapPacket(class_2960 rl, class_2540 buf) {
        class_2540 pb = new class_2540(Unpooled.buffer((int)buf.capacity()));
        pb.method_10812(rl);
        pb.method_10804(buf.readableBytes());
        pb.writeBytes((ByteBuf)buf);
        return pb;
    }

    void sendServerToClientLoginPacket(class_2960 resourceLocation, class_2540 buffer, int index, class_2535 manager) {
        class_2540 pb = this.wrapPacket(resourceLocation, buffer);
        manager.method_10743(NetworkDirection.LOGIN_TO_CLIENT.buildPacket((Pair<class_2540, Integer>)Pair.of((Object)pb, (Object)index), WRAPPER).getThis());
    }
}

