/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.netty.util.Attribute;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_151;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraftforge.network.ICustomPacket;
import net.minecraftforge.network.NetworkConstants;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class MCRegisterPacketHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MCRegisterPacketHandler INSTANCE = new MCRegisterPacketHandler();

    public void addChannels(Set<class_2960> locations, class_2535 manager) {
        MCRegisterPacketHandler.getFrom((class_2535)manager).locations.addAll(locations);
    }

    void registerListener(NetworkEvent evt) {
        ChannelList channelList = MCRegisterPacketHandler.getFrom(evt);
        channelList.updateFrom(evt.getSource(), evt.getPayload(), NetworkEvent.RegistrationChangeType.REGISTER);
        evt.getSource().get().setPacketHandled(true);
    }

    void unregisterListener(NetworkEvent evt) {
        ChannelList channelList = MCRegisterPacketHandler.getFrom(evt);
        channelList.updateFrom(evt.getSource(), evt.getPayload(), NetworkEvent.RegistrationChangeType.UNREGISTER);
        evt.getSource().get().setPacketHandled(true);
    }

    private static ChannelList getFrom(class_2535 manager) {
        return MCRegisterPacketHandler.fromAttr((Attribute<ChannelList>)manager.channel().attr(NetworkConstants.FML_MC_REGISTRY));
    }

    private static ChannelList getFrom(NetworkEvent event) {
        return MCRegisterPacketHandler.fromAttr(event.getSource().get().attr(NetworkConstants.FML_MC_REGISTRY));
    }

    private static ChannelList fromAttr(Attribute<ChannelList> attr) {
        attr.setIfAbsent((Object)new ChannelList());
        return (ChannelList)attr.get();
    }

    public void sendRegistry(class_2535 manager, NetworkDirection dir) {
        class_2540 pb = new class_2540(Unpooled.buffer());
        pb.writeBytes(MCRegisterPacketHandler.getFrom(manager).toByteArray());
        ICustomPacket iPacketICustomPacket = dir.buildPacket((Pair<class_2540, Integer>)Pair.of((Object)pb, (Object)0), NetworkConstants.MC_REGISTER_RESOURCE);
        manager.method_10743(iPacketICustomPacket.getThis());
    }

    public static class ChannelList {
        private Set<class_2960> locations = new HashSet<class_2960>();
        private Set<class_2960> remoteLocations = Set.of();

        public void updateFrom(Supplier<NetworkEvent.Context> source, class_2540 buffer, NetworkEvent.RegistrationChangeType changeType) {
            byte[] data = new byte[Math.max(buffer.readableBytes(), 0)];
            buffer.readBytes(data);
            Set<class_2960> oldLocations = this.locations;
            this.locations = this.bytesToResLocation(data);
            this.remoteLocations = Set.copyOf(this.locations);
            oldLocations.addAll(this.locations);
            oldLocations.stream().map(NetworkRegistry::findTarget).filter(Optional::isPresent).map(Optional::get).forEach(t -> t.dispatchEvent(new NetworkEvent.ChannelRegistrationChangeEvent(source, changeType)));
        }

        byte[] toByteArray() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            for (class_2960 rl : this.locations) {
                try {
                    bos.write(rl.toString().getBytes(StandardCharsets.UTF_8));
                    bos.write(0);
                }
                catch (IOException iOException) {}
            }
            return bos.toByteArray();
        }

        private Set<class_2960> bytesToResLocation(byte[] all) {
            HashSet<class_2960> rl = new HashSet<class_2960>();
            int last = 0;
            for (int cur = 0; cur < all.length; ++cur) {
                if (all[cur] != 0) continue;
                String s = new String(all, last, cur - last, StandardCharsets.UTF_8);
                try {
                    rl.add(new class_2960(s));
                }
                catch (class_151 ex) {
                    LOGGER.warn("Invalid channel name received: {}. Ignoring", (Object)s);
                }
                last = cur + 1;
            }
            return rl;
        }

        public Set<class_2960> getRemoteLocations() {
            return this.remoteLocations;
        }
    }
}

