/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2899;
import net.minecraft.class_2913;
import net.minecraft.class_2960;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.ICustomPacket;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public enum NetworkDirection {
    PLAY_TO_SERVER(NetworkEvent.ClientCustomPayloadEvent::new, LogicalSide.CLIENT, class_2817.class, 1, (d, i, n) -> new class_2817(n, d)),
    PLAY_TO_CLIENT(NetworkEvent.ServerCustomPayloadEvent::new, LogicalSide.SERVER, class_2658.class, 0, (d, i, n) -> new class_2658(n, d)),
    LOGIN_TO_SERVER(NetworkEvent.ClientCustomPayloadLoginEvent::new, LogicalSide.CLIENT, class_2913.class, 3, (d, i, n) -> new class_2913(i.intValue(), d)),
    LOGIN_TO_CLIENT(NetworkEvent.ServerCustomPayloadLoginEvent::new, LogicalSide.SERVER, class_2899.class, 2, (d, i, n) -> new class_2899(i.intValue(), n, d));

    private final BiFunction<ICustomPacket<?>, Supplier<NetworkEvent.Context>, NetworkEvent> eventSupplier;
    private final LogicalSide logicalSide;
    private final Class<? extends class_2596> packetClass;
    private final int otherWay;
    private final Factory factory;
    private static final Reference2ReferenceArrayMap<Class<? extends class_2596>, NetworkDirection> packetLookup;

    private NetworkDirection(BiFunction<ICustomPacket<?>, Supplier<NetworkEvent.Context>, NetworkEvent> eventSupplier, LogicalSide logicalSide, Class<? extends class_2596> clazz, int i, Factory factory) {
        this.eventSupplier = eventSupplier;
        this.logicalSide = logicalSide;
        this.packetClass = clazz;
        this.otherWay = i;
        this.factory = factory;
    }

    private Class<? extends class_2596> getPacketClass() {
        return this.packetClass;
    }

    public static <T extends ICustomPacket<?>> NetworkDirection directionFor(Class<T> customPacket) {
        return (NetworkDirection)((Object)packetLookup.get(customPacket));
    }

    public NetworkDirection reply() {
        return NetworkDirection.values()[this.otherWay];
    }

    public NetworkEvent getEvent(ICustomPacket<?> buffer, Supplier<NetworkEvent.Context> manager) {
        return this.eventSupplier.apply(buffer, manager);
    }

    public LogicalSide getOriginationSide() {
        return this.logicalSide;
    }

    public LogicalSide getReceptionSide() {
        return this.reply().logicalSide;
    }

    public <T extends class_2596<?>> ICustomPacket<T> buildPacket(Pair<class_2540, Integer> packetData, class_2960 channelName) {
        return this.factory.create((class_2540)packetData.getLeft(), (Integer)packetData.getRight(), channelName);
    }

    static {
        packetLookup = Stream.of(NetworkDirection.values()).collect(Collectors.toMap(NetworkDirection::getPacketClass, Function.identity(), (m1, m2) -> m1, Reference2ReferenceArrayMap::new));
    }

    private static interface Factory<T extends class_2596<?>> {
        public ICustomPacket<T> create(class_2540 var1, Integer var2, class_2960 var3);
    }
}

