/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2889;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.ConnectionData;
import net.minecraftforge.network.ConnectionType;
import net.minecraftforge.network.HandshakeHandler;
import net.minecraftforge.network.ICustomPacket;
import net.minecraftforge.network.MCRegisterPacketHandler;
import net.minecraftforge.network.NetworkConstants;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkInstance;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.network.filters.NetworkFilters;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class NetworkHooks {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void init() {
        LOGGER.debug("Loading Network data for FML net version: {}", (Object)NetworkConstants.init());
    }

    public static String getFMLVersion(String ip) {
        return ip.contains("\u0000") ? (Objects.equals(ip.split("\u0000")[1], "FML3") ? "FML3" : ip.split("\u0000")[1]) : "NONE";
    }

    public static ConnectionType getConnectionType(Supplier<class_2535> connection) {
        return NetworkHooks.getConnectionType(connection.get().channel());
    }

    public static ConnectionType getConnectionType(ChannelHandlerContext context) {
        return NetworkHooks.getConnectionType(context.channel());
    }

    private static ConnectionType getConnectionType(Channel channel) {
        return ConnectionType.forVersionFlag((String)channel.attr(NetworkConstants.FML_NETVERSION).get());
    }

    public static class_2596<class_2602> getEntitySpawningPacket(class_1297 entity) {
        return NetworkConstants.playChannel.toVanillaPacket(new PlayMessages.SpawnEntity(entity), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static boolean onCustomPayload(ICustomPacket<?> packet, class_2535 manager) {
        return NetworkRegistry.findTarget(packet.getName()).filter(ni -> NetworkHooks.validateSideForProcessing(packet, ni, manager)).map(ni -> ni.dispatch(packet.getDirection(), packet, manager)).orElse(Boolean.FALSE);
    }

    private static boolean validateSideForProcessing(ICustomPacket<?> packet, NetworkInstance ni, class_2535 manager) {
        if (packet.getDirection().getReceptionSide() != EffectiveSide.get()) {
            manager.method_10747((class_2561)class_2561.method_43470((String)"Illegal packet received, terminating connection"));
            return false;
        }
        return true;
    }

    public static void validatePacketDirection(NetworkDirection packetDirection, Optional<NetworkDirection> expectedDirection, class_2535 connection) {
        if (packetDirection != expectedDirection.orElse(packetDirection)) {
            connection.method_10747((class_2561)class_2561.method_43470((String)"Illegal packet received, terminating connection"));
            throw new IllegalStateException("Invalid packet received, aborting connection");
        }
    }

    public static void registerServerLoginChannel(class_2535 manager, class_2889 packet) {
        manager.channel().attr(NetworkConstants.FML_NETVERSION).set((Object)packet.getFMLVersion());
        HandshakeHandler.registerHandshake(manager, NetworkDirection.LOGIN_TO_CLIENT);
    }

    public static synchronized void registerClientLoginChannel(class_2535 manager) {
        manager.channel().attr(NetworkConstants.FML_NETVERSION).set((Object)"NONE");
        HandshakeHandler.registerHandshake(manager, NetworkDirection.LOGIN_TO_SERVER);
    }

    public static synchronized void sendMCRegistryPackets(class_2535 manager, String direction) {
        NetworkFilters.injectIfNecessary(manager);
        Set<class_2960> resourceLocations = NetworkRegistry.buildChannelVersions().keySet().stream().filter(rl -> !Objects.equals(rl.method_12836(), "minecraft")).collect(Collectors.toSet());
        MCRegisterPacketHandler.INSTANCE.addChannels(resourceLocations, manager);
        MCRegisterPacketHandler.INSTANCE.sendRegistry(manager, NetworkDirection.valueOf(direction));
    }

    public static boolean isVanillaConnection(class_2535 manager) {
        if (manager == null || manager.channel() == null) {
            throw new NullPointerException("ARGH! Network Manager is null (" + String.valueOf(manager) != null ? "CHANNEL" : "MANAGER)");
        }
        return NetworkHooks.getConnectionType(() -> manager) == ConnectionType.VANILLA;
    }

    public static void handleClientLoginSuccess(class_2535 manager) {
        manager.channel().attr(NetworkConstants.FML_NETVERSION).setIfAbsent((Object)"NONE");
        if (NetworkHooks.isVanillaConnection(manager)) {
            LOGGER.info("Connected to a vanilla server. Catching up missing behaviour.");
            ConfigTracker.INSTANCE.loadDefaultServerConfigs();
        } else {
            LOGGER.info("Connected to a modded server.");
        }
    }

    public static boolean tickNegotiation(class_3248 netHandlerLoginServer, class_2535 networkManager, class_3222 player) {
        return HandshakeHandler.tickLogin(networkManager);
    }

    public static void openScreen(class_3222 player, class_3908 containerSupplier) {
        NetworkHooks.openScreen(player, containerSupplier, (class_2540 buf) -> {});
    }

    public static void openScreen(class_3222 player, class_3908 containerSupplier, class_2338 pos) {
        NetworkHooks.openScreen(player, containerSupplier, (class_2540 buf) -> buf.method_10807(pos));
    }

    public static void openScreen(class_3222 player, class_3908 containerSupplier, Consumer<class_2540> extraDataWriter) {
        if (player.method_37908().field_9236) {
            return;
        }
        player.method_14247();
        player.method_14237();
        int openContainerId = player.field_13986;
        class_2540 extraData = new class_2540(Unpooled.buffer());
        extraDataWriter.accept(extraData);
        extraData.readerIndex(0);
        class_2540 output = new class_2540(Unpooled.buffer());
        output.method_10804(extraData.readableBytes());
        output.writeBytes((ByteBuf)extraData);
        if (output.readableBytes() > 32600 || output.readableBytes() < 1) {
            throw new IllegalArgumentException("Invalid PacketBuffer for openGui, found " + output.readableBytes() + " bytes");
        }
        class_1703 c = containerSupplier.createMenu(openContainerId, player.method_31548(), (class_1657)player);
        if (c == null) {
            return;
        }
        class_3917 type = c.method_17358();
        PlayMessages.OpenContainer msg = new PlayMessages.OpenContainer(type, openContainerId, containerSupplier.method_5476(), output);
        NetworkConstants.playChannel.sendTo(msg, player.field_13987.field_14127, NetworkDirection.PLAY_TO_CLIENT);
        player.field_7512 = c;
        player.method_14235(player.field_7512);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((class_1657)player, c));
    }

    static void appendConnectionData(class_2535 mgr, Map<String, Pair<String, String>> modData, Map<class_2960, String> channels) {
        ConnectionData oldData = (ConnectionData)mgr.channel().attr(NetworkConstants.FML_CONNECTION_DATA).get();
        oldData = oldData != null ? new ConnectionData(oldData.getModData().isEmpty() ? modData : oldData.getModData(), oldData.getChannels().isEmpty() ? channels : oldData.getChannels()) : new ConnectionData(modData, channels);
        mgr.channel().attr(NetworkConstants.FML_CONNECTION_DATA).set((Object)oldData);
    }

    @Nullable
    public static ConnectionData getConnectionData(class_2535 mgr) {
        return (ConnectionData)mgr.channel().attr(NetworkConstants.FML_CONNECTION_DATA).get();
    }

    @Nullable
    public static ConnectionData.ModMismatchData getModMismatchData(class_2535 mgr) {
        return (ConnectionData.ModMismatchData)mgr.channel().attr(NetworkConstants.FML_MOD_MISMATCH_DATA).get();
    }

    @Nullable
    public static MCRegisterPacketHandler.ChannelList getChannelList(class_2535 mgr) {
        return (MCRegisterPacketHandler.ChannelList)mgr.channel().attr(NetworkConstants.FML_MC_REGISTRY).get();
    }
}

