/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PacketDistributor<T> {
    public static final PacketDistributor<class_3222> PLAYER = new PacketDistributor(PacketDistributor::playerConsumer, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<class_5321<class_1937>> DIMENSION = new PacketDistributor(PacketDistributor::playerListDimConsumer, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<TargetPoint> NEAR = new PacketDistributor(PacketDistributor::playerListPointConsumer, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<Void> ALL = new PacketDistributor(PacketDistributor::playerListAll, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<Void> SERVER = new PacketDistributor(PacketDistributor::clientToServer, NetworkDirection.PLAY_TO_SERVER);
    public static final PacketDistributor<class_1297> TRACKING_ENTITY = new PacketDistributor(PacketDistributor::trackingEntity, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<class_1297> TRACKING_ENTITY_AND_SELF = new PacketDistributor(PacketDistributor::trackingEntityAndSelf, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<class_2818> TRACKING_CHUNK = new PacketDistributor(PacketDistributor::trackingChunk, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<List<class_2535>> NMLIST = new PacketDistributor(PacketDistributor::networkManagerList, NetworkDirection.PLAY_TO_CLIENT);
    private final BiFunction<PacketDistributor<T>, Supplier<T>, Consumer<class_2596<?>>> functor;
    private final NetworkDirection direction;

    public PacketDistributor(BiFunction<PacketDistributor<T>, Supplier<T>, Consumer<class_2596<?>>> functor, NetworkDirection direction) {
        this.functor = functor;
        this.direction = direction;
    }

    public PacketTarget with(Supplier<T> input) {
        return new PacketTarget(this.functor.apply(this, input), this);
    }

    public PacketTarget noArg() {
        return new PacketTarget(this.functor.apply(this, () -> null), this);
    }

    private Consumer<class_2596<?>> playerConsumer(Supplier<class_3222> entityPlayerMPSupplier) {
        return p -> ((class_3222)entityPlayerMPSupplier.get()).field_13987.field_14127.method_10743(p);
    }

    private Consumer<class_2596<?>> playerListDimConsumer(Supplier<class_5321<class_1937>> dimensionTypeSupplier) {
        return p -> this.getServer().method_3760().method_14589(p, (class_5321)dimensionTypeSupplier.get());
    }

    private Consumer<class_2596<?>> playerListAll(Supplier<Void> voidSupplier) {
        return p -> this.getServer().method_3760().method_14581(p);
    }

    private Consumer<class_2596<?>> clientToServer(Supplier<Void> voidSupplier) {
        return p -> class_310.method_1551().method_1562().method_2883(p);
    }

    private Consumer<class_2596<?>> playerListPointConsumer(Supplier<TargetPoint> targetPointSupplier) {
        return p -> {
            TargetPoint tp = (TargetPoint)targetPointSupplier.get();
            this.getServer().method_3760().method_14605((class_1657)tp.excluded, tp.x, tp.y, tp.z, tp.r2, tp.dim, p);
        };
    }

    private Consumer<class_2596<?>> trackingEntity(Supplier<class_1297> entitySupplier) {
        return p -> {
            class_1297 entity = (class_1297)entitySupplier.get();
            ((class_3215)entity.method_5770().method_8398()).method_18754(entity, p);
        };
    }

    private Consumer<class_2596<?>> trackingEntityAndSelf(Supplier<class_1297> entitySupplier) {
        return p -> {
            class_1297 entity = (class_1297)entitySupplier.get();
            ((class_3215)entity.method_5770().method_8398()).method_18751(entity, p);
        };
    }

    private Consumer<class_2596<?>> trackingChunk(Supplier<class_2818> chunkPosSupplier) {
        return p -> {
            class_2818 chunk = (class_2818)chunkPosSupplier.get();
            ((class_3215)chunk.method_12200().method_8398()).field_17254.method_17210(chunk.method_12004(), false).forEach(e -> e.field_13987.method_14364(p));
        };
    }

    private Consumer<class_2596<?>> networkManagerList(Supplier<List<class_2535>> nmListSupplier) {
        return p -> ((List)nmListSupplier.get()).forEach(nm -> nm.method_10743(p));
    }

    private MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static class PacketTarget {
        private final Consumer<class_2596<?>> packetConsumer;
        private final PacketDistributor<?> distributor;

        PacketTarget(Consumer<class_2596<?>> packetConsumer, PacketDistributor<?> distributor) {
            this.packetConsumer = packetConsumer;
            this.distributor = distributor;
        }

        public void send(class_2596<?> packet) {
            this.packetConsumer.accept(packet);
        }

        public NetworkDirection getDirection() {
            return this.distributor.direction;
        }
    }

    public static final class TargetPoint {
        private final class_3222 excluded;
        private final double x;
        private final double y;
        private final double z;
        private final double r2;
        private final class_5321<class_1937> dim;

        public TargetPoint(class_3222 excluded, double x, double y, double z, double r2, class_5321<class_1937> dim) {
            this.excluded = excluded;
            this.x = x;
            this.y = y;
            this.z = z;
            this.r2 = r2;
            this.dim = dim;
        }

        public TargetPoint(double x, double y, double z, double r2, class_5321<class_1937> dim) {
            this.excluded = null;
            this.x = x;
            this.y = y;
            this.z = z;
            this.r2 = r2;
            this.dim = dim;
        }

        public static Supplier<TargetPoint> p(double x, double y, double z, double r2, class_5321<class_1937> dim) {
            TargetPoint tp = new TargetPoint(x, y, z, r2, dim);
            return () -> tp;
        }
    }
}

