/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkConstants;
import net.minecraftforge.network.NetworkRegistry;

public record ServerStatusPing(Map<class_2960, ChannelData> channels, Map<String, String> mods, int fmlNetworkVer, boolean truncated) {
    private static final Codec<ByteBuf> BYTE_BUF_CODEC = Codec.STRING.xmap(ServerStatusPing::decodeOptimized, ServerStatusPing::encodeOptimized);
    public static final Codec<ServerStatusPing> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.INT.fieldOf("fmlNetworkVersion").forGetter(ServerStatusPing::getFMLNetworkVersion), (App)BYTE_BUF_CODEC.optionalFieldOf("d").forGetter(ping -> Optional.of(ping.toBuf())), (App)ChannelData.CODEC.listOf().optionalFieldOf("channels").forGetter(ping -> Optional.of(List.of())), (App)ModInfo.CODEC.listOf().optionalFieldOf("mods").forGetter(ping -> Optional.of(List.of())), (App)Codec.BOOL.optionalFieldOf("truncated").forGetter(ping -> Optional.of(ping.isTruncated()))).apply((Applicative)in, (fmlVer, buf, channels, mods, truncated) -> buf.map(byteBuf -> ServerStatusPing.deserializeOptimized(fmlVer, byteBuf)).orElseGet(() -> new ServerStatusPing(channels.orElseGet(List::of).stream().collect(Collectors.toMap(ChannelData::res, Function.identity())), mods.orElseGet(List::of).stream().collect(Collectors.toMap(ModInfo::modId, ModInfo::modmarker)), (int)fmlVer, truncated.orElse(false)))));
    private static final int VERSION_FLAG_IGNORESERVERONLY = 1;

    public ServerStatusPing() {
        this(NetworkRegistry.buildChannelVersionsForListPing(), (Map)class_156.method_654(new HashMap(), map -> ModList.get().forEachModContainer((modid, mc) -> map.put(modid, mc.getCustomExtension(IExtensionPoint.DisplayTest.class).map(IExtensionPoint.DisplayTest::suppliedVersion).map(Supplier::get).orElse(NetworkConstants.IGNORESERVERONLY)))), 3, false);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerStatusPing)) {
            return false;
        }
        ServerStatusPing that = (ServerStatusPing)o;
        return this.fmlNetworkVer == that.fmlNetworkVer && this.channels.equals(that.channels) && this.mods.equals(that.mods);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.channels, this.mods, this.fmlNetworkVer);
    }

    private List<Map.Entry<class_2960, ChannelData>> getChannelsForMod(String modId) {
        return this.channels.entrySet().stream().filter(c -> ((class_2960)c.getKey()).method_12836().equals(modId)).toList();
    }

    private List<Map.Entry<class_2960, ChannelData>> getNonModChannels() {
        return this.channels.entrySet().stream().filter(c -> !this.mods.containsKey(((class_2960)c.getKey()).method_12836())).toList();
    }

    public ByteBuf toBuf() {
        boolean reachedSizeLimit = false;
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeBoolean(false);
        buf.writeShort(this.mods.size());
        int writtenCount = 0;
        for (Map.Entry<String, String> modEntry : this.mods.entrySet()) {
            boolean isIgnoreServerOnly = modEntry.getValue().equals(NetworkConstants.IGNORESERVERONLY);
            List<Map.Entry<class_2960, ChannelData>> channelsForMod = this.getChannelsForMod(modEntry.getKey());
            int channelSizeAndVersionFlag = channelsForMod.size() << 1;
            if (isIgnoreServerOnly) {
                channelSizeAndVersionFlag |= 1;
            }
            buf.method_10804(channelSizeAndVersionFlag);
            buf.method_10814(modEntry.getKey());
            if (!isIgnoreServerOnly) {
                buf.method_10814(modEntry.getValue());
            }
            for (Map.Entry<class_2960, ChannelData> entry : channelsForMod) {
                buf.method_10814(entry.getKey().method_12832());
                buf.method_10814(entry.getValue().version());
                buf.writeBoolean(entry.getValue().required());
            }
            ++writtenCount;
            if (buf.readableBytes() < 60000) continue;
            reachedSizeLimit = true;
            break;
        }
        if (!reachedSizeLimit) {
            List<Map.Entry<class_2960, ChannelData>> nonModChannels = this.getNonModChannels();
            buf.method_10804(nonModChannels.size());
            for (Map.Entry<class_2960, ChannelData> entry : nonModChannels) {
                buf.method_10812(entry.getKey());
                buf.method_10814(entry.getValue().version());
                buf.writeBoolean(entry.getValue().required());
            }
        } else {
            buf.setShort(1, writtenCount);
            buf.method_10804(0);
        }
        buf.setBoolean(0, reachedSizeLimit);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServerStatusPing deserializeOptimized(int fmlNetworkVersion, ByteBuf bbuf) {
        HashMap<class_2960, ChannelData> channels;
        HashMap<String, String> mods;
        boolean truncated;
        class_2540 buf = new class_2540(bbuf);
        try {
            truncated = buf.readBoolean();
            int modsSize = buf.readUnsignedShort();
            mods = new HashMap<String, String>();
            channels = new HashMap<class_2960, ChannelData>();
            for (int i = 0; i < modsSize; ++i) {
                int channelSizeAndVersionFlag = buf.method_10816();
                int channelSize = channelSizeAndVersionFlag >>> 1;
                boolean isIgnoreServerOnly = (channelSizeAndVersionFlag & 1) != 0;
                String modId = buf.method_19772();
                String modVersion = isIgnoreServerOnly ? NetworkConstants.IGNORESERVERONLY : buf.method_19772();
                for (int i1 = 0; i1 < channelSize; ++i1) {
                    String channelName = buf.method_19772();
                    String channelVersion = buf.method_19772();
                    boolean requiredOnClient = buf.readBoolean();
                    class_2960 id = new class_2960(modId, channelName);
                    channels.put(id, new ChannelData(id, channelVersion, requiredOnClient));
                }
                mods.put(modId, modVersion);
            }
            int nonModChannelCount = buf.method_10816();
            for (int i = 0; i < nonModChannelCount; ++i) {
                class_2960 channelName = buf.method_10810();
                String channelVersion = buf.method_19772();
                boolean requiredOnClient = buf.readBoolean();
                channels.put(channelName, new ChannelData(channelName, channelVersion, requiredOnClient));
            }
        }
        finally {
            buf.release();
        }
        return new ServerStatusPing(channels, mods, fmlNetworkVersion, truncated);
    }

    private static String encodeOptimized(ByteBuf buf) {
        char c;
        int byteLength = buf.readableBytes();
        StringBuilder sb = new StringBuilder();
        sb.append((char)(byteLength & Short.MAX_VALUE));
        sb.append((char)(byteLength >>> 15 & Short.MAX_VALUE));
        int buffer = 0;
        int bitsInBuf = 0;
        while (buf.isReadable()) {
            if (bitsInBuf >= 15) {
                c = (char)(buffer & Short.MAX_VALUE);
                sb.append(c);
                buffer >>>= 15;
                bitsInBuf -= 15;
            }
            short b = buf.readUnsignedByte();
            buffer |= b << bitsInBuf;
            bitsInBuf += 8;
        }
        buf.release();
        if (bitsInBuf > 0) {
            c = (char)(buffer & Short.MAX_VALUE);
            sb.append(c);
        }
        return sb.toString();
    }

    private static ByteBuf decodeOptimized(String s) {
        char size0 = s.charAt(0);
        char size1 = s.charAt(1);
        int size = size0 | size1 << 15;
        ByteBuf buf = Unpooled.buffer((int)size);
        int buffer = 0;
        int bitsInBuf = 0;
        for (int stringIndex = 2; stringIndex < s.length(); ++stringIndex) {
            while (bitsInBuf >= 8) {
                buf.writeByte(buffer);
                buffer >>>= 8;
                bitsInBuf -= 8;
            }
            char c = s.charAt(stringIndex);
            buffer |= (c & Short.MAX_VALUE) << bitsInBuf;
            bitsInBuf += 15;
        }
        while (buf.readableBytes() < size) {
            buf.writeByte(buffer);
            buffer >>>= 8;
            bitsInBuf -= 8;
        }
        return buf;
    }

    public Map<class_2960, ChannelData> getRemoteChannels() {
        return this.channels;
    }

    public Map<String, String> getRemoteModData() {
        return this.mods;
    }

    public int getFMLNetworkVersion() {
        return this.fmlNetworkVer;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public record ChannelData(class_2960 res, String version, boolean required) {
        public static final Codec<ChannelData> CODEC = RecordCodecBuilder.create(in -> in.group((App)class_2960.field_25139.fieldOf("res").forGetter(ChannelData::res), (App)Codec.STRING.fieldOf("version").forGetter(ChannelData::version), (App)Codec.BOOL.fieldOf("required").forGetter(ChannelData::required)).apply((Applicative)in, ChannelData::new));
    }

    public record ModInfo(String modId, String modmarker) {
        public static final Codec<ModInfo> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.STRING.fieldOf("modId").forGetter(ModInfo::modId), (App)Codec.STRING.fieldOf("modmarker").forGetter(ModInfo::modmarker)).apply((Applicative)in, ModInfo::new));
    }
}

