/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.filters;

import com.google.common.collect.ImmutableMap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2535;
import net.minecraftforge.network.filters.ForgeConnectionNetworkFilter;
import net.minecraftforge.network.filters.VanillaConnectionNetworkFilter;
import net.minecraftforge.network.filters.VanillaPacketFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkFilters {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Function<class_2535, VanillaPacketFilter>> instances = ImmutableMap.of((Object)"forge:vanilla_filter", manager -> new VanillaConnectionNetworkFilter(), (Object)"forge:forge_fixes", ForgeConnectionNetworkFilter::new);

    public static void injectIfNecessary(class_2535 manager) {
        ChannelPipeline pipeline = manager.channel().pipeline();
        if (pipeline.get("packet_handler") == null) {
            return;
        }
        instances.forEach((key, filterFactory) -> {
            VanillaPacketFilter filter2 = (VanillaPacketFilter)((Object)((Object)filterFactory.apply(manager)));
            if (filter2.isNecessary(manager)) {
                pipeline.addBefore("packet_handler", key, (ChannelHandler)filter2);
                LOGGER.debug("Injected {} into {}", (Object)filter2, (Object)manager);
            }
        });
    }

    private NetworkFilters() {
    }
}

