/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.Iterators;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.ForgeRegistryTag;
import net.minecraftforge.registries.NamespacedWrapper;
import net.minecraftforge.registries.tags.IReverseTag;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;
import xyz.bluspring.kilt.util.registry.NoopRegistry;
import xyz.bluspring.kilt.util.registry.VanillaForgeRegistry;

class ForgeRegistryTagManager<V>
implements ITagManager<V> {
    private final ForgeRegistry<V> owner;
    private volatile Map<class_6862<V>, ITag<V>> tags = new IdentityHashMap<class_6862<V>, ITag<V>>();

    ForgeRegistryTagManager(ForgeRegistry<V> owner) {
        this.owner = owner;
    }

    @Override
    public void kilt$bindTags(Map<class_6862<V>, class_6885.class_6888<V>> holderTags) {
        this.bind(holderTags, null);
    }

    void bind(Map<class_6862<V>, class_6885.class_6888<V>> holderTags, Set<class_6862<V>> defaultedTags) {
        IdentityHashMap newTags = new IdentityHashMap(this.tags);
        newTags.values().forEach(tag -> ((ForgeRegistryTag)tag).bind(null));
        holderTags.forEach((? super K key, ? super V holderSet) -> ((ForgeRegistryTag)newTags.computeIfAbsent((class_6862)key, ForgeRegistryTag::new)).bind(holderSet));
        this.tags = newTags;
    }

    @Override
    @NotNull
    public ITag<V> getTag(@NotNull class_6862<V> name) {
        Objects.requireNonNull(name);
        ITag<V> tag = this.tags.get(name);
        if (tag == null) {
            VanillaForgeRegistry reg;
            tag = new ForgeRegistryTag<V>(name);
            ForgeRegistry<V> forgeRegistry = this.owner;
            if (forgeRegistry instanceof VanillaForgeRegistry && !((reg = (VanillaForgeRegistry)forgeRegistry).getVanillaRegistry() instanceof NoopRegistry)) {
                ((ForgeRegistryTag)tag).bind(reg.getVanillaRegistry().method_40260(name));
            }
            IdentityHashMap<class_6862<ITag<ITag<V>>>, ITag<ITag<ITag<V>>>> map = new IdentityHashMap<class_6862<ITag<ITag<V>>>, ITag<ITag<ITag<V>>>>(this.tags);
            map.put(name, tag);
            this.tags = map;
        }
        return tag;
    }

    @Override
    @NotNull
    public Optional<IReverseTag<V>> getReverseTag(@NotNull V value) {
        Objects.requireNonNull(value);
        return this.owner.getHolder(value);
    }

    @Override
    public boolean isKnownTagName(@NotNull class_6862<V> name) {
        Objects.requireNonNull(name);
        ITag<V> tag = this.tags.get(name);
        return tag != null && tag.isBound();
    }

    @Override
    @NotNull
    public Iterator<ITag<V>> iterator() {
        return Iterators.unmodifiableIterator(this.tags.values().iterator());
    }

    @Override
    @NotNull
    public Stream<ITag<V>> stream() {
        return this.tags.values().stream();
    }

    @Override
    @NotNull
    public Stream<class_6862<V>> getTagNames() {
        return this.tags.keySet().stream();
    }

    @Override
    @NotNull
    public class_6862<V> createTagKey(@NotNull class_2960 location) {
        Objects.requireNonNull(location);
        return class_6862.method_40092(this.owner.getRegistryKey(), (class_2960)location);
    }

    @Override
    @NotNull
    public class_6862<V> createOptionalTagKey(@NotNull class_2960 location, @NotNull Set<? extends Supplier<V>> defaults) {
        class_6862<V> tagKey = this.createTagKey(location);
        this.addOptionalTagDefaults(tagKey, defaults);
        return tagKey;
    }

    @Override
    public void addOptionalTagDefaults(@NotNull class_6862<V> name, @NotNull Set<? extends Supplier<V>> defaults) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(defaults);
        NamespacedWrapper<V> wrapper = this.owner.getWrapper();
        if (wrapper != null) {
            wrapper.addOptionalTag(name, defaults);
        }
    }
}

