/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraftforge.eventbus.api.Event;

public class IdMappingEvent
extends Event {
    private final Map<class_2960, ImmutableList<ModRemapping>> remaps;
    private final ImmutableSet<class_2960> keys;
    private final boolean isFrozen;

    public IdMappingEvent(Map<class_2960, Map<class_2960, IdRemapping>> remaps, boolean isFrozen) {
        this.isFrozen = isFrozen;
        this.remaps = Maps.newHashMap();
        remaps.forEach((name, rm) -> {
            ArrayList tmp = Lists.newArrayList();
            rm.forEach((key, value) -> tmp.add(new ModRemapping((class_2960)name, (class_2960)key, value.currId, value.newId)));
            tmp.sort(Comparator.comparingInt(o -> o.newId));
            this.remaps.put((class_2960)name, (ImmutableList<ModRemapping>)ImmutableList.copyOf((Collection)tmp));
        });
        this.keys = ImmutableSet.copyOf(this.remaps.keySet());
    }

    public ImmutableSet<class_2960> getRegistries() {
        return this.keys;
    }

    public ImmutableList<ModRemapping> getRemaps(class_2960 registry) {
        return this.remaps.get(registry);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public static class ModRemapping {
        public final class_2960 registry;
        public final class_2960 key;
        public final int oldId;
        public final int newId;

        private ModRemapping(class_2960 registry, class_2960 key, int oldId, int newId) {
            this.registry = registry;
            this.key = key;
            this.oldId = oldId;
            this.newId = newId;
        }
    }

    public record IdRemapping(int currId, int newId) {
    }
}

